/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml;

import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import org.citygml4j.core.ade.ADEException;
import org.citygml4j.core.ade.ADERegistry;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.xml.CityGMLADELoader;
import org.citygml4j.xml.CityGMLContextException;
import org.citygml4j.xml.ade.CityGMLADE;
import org.citygml4j.xml.module.ade.ADEModule;
import org.citygml4j.xml.module.citygml.CityGMLModules;
import org.citygml4j.xml.reader.CityGMLInputFactory;
import org.citygml4j.xml.reader.CityGMLReadException;
import org.citygml4j.xml.schema.CityGMLSchemaHandler;
import org.citygml4j.xml.writer.CityGMLOutputFactory;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.XMLObjectsException;
import org.xmlobjects.schema.SchemaHandlerException;
import org.xmlobjects.util.xml.SecureXMLProcessors;

public class CityGMLContext {
    private final XMLObjects xmlObjects;
    private CityGMLSchemaHandler schemaHandler;

    private CityGMLContext(ClassLoader classLoader) throws CityGMLContextException {
        try {
            this.xmlObjects = XMLObjects.newInstance((ClassLoader)classLoader);
        }
        catch (XMLObjectsException e) {
            throw new CityGMLContextException("Failed to instantiate XML objects.", e);
        }
        try {
            ADERegistry registry = ADERegistry.getInstance();
            for (CityGMLADE ade : registry.getADEs(CityGMLADE.class)) {
                if (ade.getClass().getClassLoader() == classLoader) continue;
                this.loadADE(ade);
            }
            this.removeUnregisteredADEObjects();
            ((CityGMLADELoader)registry.getADELoader(CityGMLADELoader.class)).addListener(this);
        }
        catch (ADEException e) {
            throw new CityGMLContextException("Failed to load CityGML ADEs.", e);
        }
    }

    public static CityGMLContext newInstance(ClassLoader classLoader) throws CityGMLContextException {
        return new CityGMLContext(classLoader);
    }

    public static CityGMLContext newInstance() throws CityGMLContextException {
        return CityGMLContext.newInstance(Thread.currentThread().getContextClassLoader());
    }

    public XMLObjects getXMLObjects() {
        return this.xmlObjects;
    }

    public CityGMLInputFactory createCityGMLInputFactory(XMLInputFactory factory) throws CityGMLReadException {
        return new CityGMLInputFactory(this, factory);
    }

    public CityGMLInputFactory createCityGMLInputFactory() throws CityGMLReadException {
        return this.createCityGMLInputFactory(SecureXMLProcessors.newXMLInputFactory());
    }

    public CityGMLOutputFactory createCityGMLOutputFactory(CityGMLVersion version) {
        return new CityGMLOutputFactory(version, this);
    }

    public CityGMLOutputFactory createCityGMLOutputFactory() {
        return new CityGMLOutputFactory(CityGMLVersion.v3_0, this);
    }

    public CityGMLSchemaHandler getDefaultSchemaHandler() throws SchemaHandlerException {
        if (this.schemaHandler == null) {
            this.schemaHandler = CityGMLSchemaHandler.newInstance();
        }
        return this.schemaHandler;
    }

    void loadADE(CityGMLADE ade) throws ADEException {
        try {
            this.loadADEObjects(ade.getClass().getClassLoader());
        }
        catch (XMLObjectsException e) {
            throw new ADEException("Failed to load ADE.", (Throwable)e);
        }
    }

    void unloadADE(CityGMLADE ade) {
        for (ADEModule module : ade.getADEModules()) {
            this.unloadADEObjects(module.getNamespaceURI());
        }
    }

    private void loadADEObjects(ClassLoader classLoader) throws XMLObjectsException {
        this.xmlObjects.loadBuilders(classLoader, false);
        this.xmlObjects.loadSerializers(classLoader, false);
        this.removeUnregisteredADEObjects();
    }

    private void unloadADEObjects(String namespaceURI) {
        this.xmlObjects.unloadBuilders(namespaceURI);
        this.xmlObjects.unloadSerializers(namespaceURI);
    }

    private void removeUnregisteredADEObjects() {
        CityGMLADELoader loader = (CityGMLADELoader)ADERegistry.getInstance().getADELoader(CityGMLADELoader.class);
        Set<String> adeNamespaces = loader.getADENamespaces();
        for (String namespaceURI : this.xmlObjects.getSerializableNamespaces()) {
            if (CityGMLModules.isCityGMLNamespace(namespaceURI) || CityGMLModules.isGMLNamespace(namespaceURI) || CityGMLModules.isXALNamespace(namespaceURI) || adeNamespaces.contains(namespaceURI)) continue;
            this.unloadADEObjects(namespaceURI);
        }
    }
}

