/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.cityobjectgroup.CityObjectGroup;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.util.reference.Referees;
import org.citygml4j.core.visitor.ObjectWalker;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.base.AbstractInlineOrByReferenceProperty;
import org.xmlobjects.gml.model.base.AbstractReference;
import org.xmlobjects.gml.model.base.ResolvableAssociation;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.visitor.Visitable;
import org.xmlobjects.model.Child;

public class ReferenceResolver {
    private final List<CityObjectGroup> groups = new ArrayList<CityObjectGroup>();
    private final List<AbstractGeometry> templates = new ArrayList<AbstractGeometry>();
    private final Map<String, List<ResolvableAssociation<?>>> globalProperties = new HashMap();

    ReferenceResolver() {
    }

    List<CityObjectGroup> getCityObjectGroups() {
        return this.groups;
    }

    void add(CityObjectGroup group) {
        this.groups.add(group);
        this.populateProperties((AbstractFeature)group, this.globalProperties);
    }

    List<AbstractGeometry> getTemplateGeometries() {
        return this.templates;
    }

    void add(AbstractGeometry geometry) {
        if (geometry.getId() != null) {
            this.templates.add(geometry);
        }
    }

    void add(Appearance appearance) {
        this.populateProperties((AbstractFeature)appearance, this.globalProperties);
    }

    void initialize() {
        this.templates.forEach(this::resolveReferences);
    }

    void resolveReferences(Visitable visitable) {
        ArrayList<AbstractGML> objects = new ArrayList<AbstractGML>();
        HashMap properties = new HashMap();
        this.populate(visitable, objects, properties);
        objects.forEach(object -> {
            this.resolveReferences((AbstractGML)object, properties);
            this.resolveReferences((AbstractGML)object, this.globalProperties);
        });
        this.templates.forEach(template -> this.resolveReferences((AbstractGML)template, properties));
    }

    private void resolveReferences(AbstractGML object, Map<String, List<ResolvableAssociation<?>>> properties) {
        List<ResolvableAssociation<?>> candidates = properties.get(object.getId());
        if (candidates != null) {
            for (ResolvableAssociation<?> candidate : candidates) {
                ((Referees)object.getLocalProperties().getOrSet(Referees.PROPERTY_NAME, Referees.class, Referees::new)).add(candidate.getParent());
                if (properties == this.globalProperties) continue;
                candidate.setReferencedObjectIfValid((Child)object, false);
            }
        }
    }

    private void populateProperties(AbstractFeature feature, Map<String, List<ResolvableAssociation<?>>> properties) {
        this.populate((Visitable)feature, null, properties);
    }

    private void populate(Visitable visitable, final List<AbstractGML> objects, final Map<String, List<ResolvableAssociation<?>>> properties) {
        ObjectWalker walker = new ObjectWalker(){

            public void visit(AbstractGML object) {
                if (objects != null && object.getId() != null) {
                    objects.add(object);
                }
            }

            public void visit(AbstractInlineOrByReferenceProperty<?> property) {
                this.add((ResolvableAssociation<?>)property, property.getHref());
                super.visit(property);
            }

            public void visit(AbstractReference<?> reference) {
                this.add((ResolvableAssociation<?>)reference, reference.getHref());
            }

            private void add(ResolvableAssociation<?> association, String reference) {
                if (reference != null && AbstractGML.class.isAssignableFrom(association.getTargetType())) {
                    int index = reference.lastIndexOf("#");
                    properties.computeIfAbsent(index != -1 ? reference.substring(index + 1) : reference, v -> new ArrayList()).add(association);
                }
            }
        };
        walker.visit(visitable);
    }

    void clear() {
        this.groups.clear();
        this.templates.clear();
        this.globalProperties.clear();
    }
}

