/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.writer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.citygml4j.cityjson.model.CityJSONType;
import org.citygml4j.cityjson.writer.AbstractCityJSONWriter;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.cityobjectgroup.CityObjectGroup;
import org.citygml4j.core.model.core.AbstractFeature;

public class CityJSONWriter
extends AbstractCityJSONWriter<CityJSONWriter> {
    private String indent;

    CityJSONWriter(JsonGenerator writer) {
        super(writer);
    }

    public String getIndent() {
        return this.indent;
    }

    public CityJSONWriter withIndent(String indent) {
        this.indent = indent;
        DefaultPrettyPrinter printer = null;
        if (indent != null) {
            DefaultIndenter indenter = new DefaultIndenter(this.indent, "\n");
            printer = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter).withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter);
        }
        this.writer.setPrettyPrinter(printer);
        return this;
    }

    @Override
    void writeStartDocument(AbstractFeature feature) throws CityJSONWriteException {
        super.writeStartDocument(feature);
        try {
            this.writer.writeStartObject();
            this.writer.writeStringField("type", CityJSONType.CITYJSON.toTypeName());
            this.writer.writeStringField("version", this.helper.getVersion().toValue());
            this.writer.writeObjectFieldStart("CityObjects");
            this.getAndSetReferenceSystem(feature);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
        finally {
            this.state = AbstractCityJSONWriter.State.DOCUMENT_STARTED;
        }
    }

    @Override
    void writeCityObject(String id, ObjectNode node) throws CityJSONWriteException {
        try {
            this.writer.writeObjectField(id, (Object)node);
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    @Override
    void writeChildObject(String id, ObjectNode node) throws CityJSONWriteException {
        this.writeCityObject(id, node);
    }

    private void writeEndDocument() throws CityJSONWriteException {
        if (this.state == AbstractCityJSONWriter.State.INITIAL) {
            this.writeStartDocument(null);
        }
        for (CityObjectGroup group : this.referenceResolver.getCityObjectGroups()) {
            this.writeCityObject((AbstractFeature)group);
        }
        try {
            this.writer.writeEndObject();
            this.writeVertices(true);
            this.writeMetadata();
            this.writeExtensions();
            this.writeAppearance();
            this.writeTemplates();
            this.writeExtraRootProperties();
            this.writer.writeEndObject();
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    @Override
    public void close() throws CityJSONWriteException {
        if (this.state == AbstractCityJSONWriter.State.CLOSED) {
            throw new CityJSONWriteException("The writer has already been closed.");
        }
        try {
            this.writeEndDocument();
            super.close();
        }
        finally {
            this.state = AbstractCityJSONWriter.State.CLOSED;
        }
    }

    @Override
    CityJSONWriter self() {
        return this;
    }
}

