/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.util;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ArrayBuffer<E>
implements Iterable<E> {
    private static final int DEFAULT_CAPACITY = 4096;
    private Object[] elements;
    private final int capacity;
    private int size;
    private int modCount;

    public ArrayBuffer(int capacity) {
        this.elements = capacity > 0 ? new Object[capacity] : new Object[4096];
        this.capacity = this.elements.length;
    }

    public ArrayBuffer() {
        this(4096);
    }

    public E get(int index) {
        Objects.checkIndex(index, this.size);
        return (E)this.elements[index];
    }

    public void add(E element) {
        ++this.modCount;
        if (this.size == this.elements.length) {
            this.grow(this.elements.length + this.capacity);
        }
        this.elements[this.size++] = element;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        ++this.modCount;
        this.elements = new Object[this.capacity];
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayBufferIterator();
    }

    private void grow(int newCapacity) {
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }

    private class ArrayBufferIterator
    implements Iterator<E> {
        private final int expectedModCount;
        private int cursor;

        private ArrayBufferIterator() {
            this.expectedModCount = ArrayBuffer.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayBuffer.this.size;
        }

        @Override
        public E next() {
            if (this.expectedModCount != ArrayBuffer.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor >= ArrayBuffer.this.size) {
                throw new NoSuchElementException();
            }
            return ArrayBuffer.this.elements[this.cursor++];
        }
    }
}

