/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.tunnel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.core.AbstractUnoccupiedSpaceAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.tunnel.DeprecatedPropertiesOfHollowSpace;
import org.citygml4j.core.model.tunnel.HollowSpace;
import org.citygml4j.core.model.tunnel.TunnelFurniture;
import org.citygml4j.core.model.tunnel.TunnelFurnitureProperty;
import org.citygml4j.core.model.tunnel.TunnelInstallation;
import org.citygml4j.core.model.tunnel.TunnelInstallationProperty;

@CityJSONElements(value={@CityJSONElement(name="TunnelHollowSpace", schema="CityJSON-Core", version=CityJSONVersion.v2_0), @CityJSONElement(name="TunnelHollowSpace", schema="CityJSON-Core", version=CityJSONVersion.v1_1)})
public class HollowSpaceAdapter
extends AbstractUnoccupiedSpaceAdapter<HollowSpace> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID);

    @Override
    public HollowSpace createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new HollowSpace();
    }

    @Override
    public void buildObject(HollowSpace object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        Iterator children = node.path("children").elements();
        block8: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "TunnelInstallation": {
                    object.getTunnelInstallations().add(new TunnelInstallationProperty(helper.getCityObject(child, TunnelInstallation.class)));
                    break;
                }
                case "TunnelFurniture": {
                    object.getTunnelFurniture().add(new TunnelFurnitureProperty(helper.getCityObject(child, TunnelFurniture.class)));
                    break;
                }
                default: {
                    continue block8;
                }
            }
            children.remove();
        }
    }

    @Override
    public String createType(HollowSpace object, CityJSONVersion version) throws CityJSONSerializeException {
        return "TunnelHollowSpace";
    }

    @Override
    public void writeObject(HollowSpace object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetTunnelInstallations()) {
            for (TunnelInstallationProperty property : object.getTunnelInstallations()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((TunnelInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetTunnelFurniture()) {
            for (TunnelInstallationProperty property : object.getTunnelFurniture()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((TunnelFurniture)property.getObject(), (AbstractFeature)object, node);
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(HollowSpace object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfHollowSpace properties = object.getDeprecatedProperties();
            return Map.of(4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfHollowSpace)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfHollowSpace)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

