/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.relief;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.relief.AbstractReliefComponentAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.appearance.AbstractSurfaceData;
import org.citygml4j.core.model.appearance.AbstractSurfaceDataProperty;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.appearance.GeometryReference;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.TextureAssociation;
import org.citygml4j.core.model.appearance.TextureAssociationProperty;
import org.citygml4j.core.model.appearance.X3DMaterial;
import org.citygml4j.core.model.core.AbstractAppearance;
import org.citygml4j.core.model.core.AbstractAppearanceProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.relief.TINRelief;
import org.citygml4j.core.model.relief.TinProperty;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSurface;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRing;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;
import org.xmlobjects.gml.model.geometry.primitives.Triangle;
import org.xmlobjects.gml.model.geometry.primitives.TriangleArrayProperty;
import org.xmlobjects.gml.model.geometry.primitives.TriangulatedSurface;
import org.xmlobjects.model.Child;

public class TINReliefAdapter
extends AbstractReliefComponentAdapter<TINRelief> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.of(GeometryType.COMPOSITE_SURFACE);

    @Override
    public TINRelief createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new TINRelief();
    }

    @Override
    public String createType(TINRelief object, CityJSONVersion version) throws CityJSONSerializeException {
        return "TINRelief";
    }

    @Override
    public void buildObject(TINRelief object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        for (JsonNode geometry : node.path("geometry")) {
            CompositeSurface compositeSurface;
            TriangulatedSurface triangulatedSurface;
            AbstractGeometry abstractGeometry;
            GeometryObject geometryObject;
            GeometryType type = GeometryType.fromValue(geometry.path("type").asText());
            if (type != GeometryType.COMPOSITE_SURFACE || (geometryObject = helper.getGeometry((AbstractFeature)object, geometry)) == null || !((abstractGeometry = geometryObject.getGeometry()) instanceof CompositeSurface) || (triangulatedSurface = this.toTriangulatedSurface(compositeSurface = (CompositeSurface)abstractGeometry)) == null) continue;
            object.setLod(geometry.path("lod").asInt(0));
            object.setTin(new TinProperty(triangulatedSurface));
            if (!geometryObject.hasAppearances()) break;
            this.addAppearances(object, geometryObject.getAppearances(), "#" + triangulatedSurface.getId());
            break;
        }
    }

    @Override
    public void writeObject(TINRelief object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        if (object.getTin() != null) {
            helper.addGeometry((GeometryProperty<?>)object.getTin(), (Number)object.getLod(), node, this.allowedTypes);
        }
    }

    private TriangulatedSurface toTriangulatedSurface(CompositeSurface compositeSurface) {
        TriangleArrayProperty triangles = new TriangleArrayProperty();
        Iterator iterator = compositeSurface.getSurfaceMembers().iterator();
        while (iterator.hasNext()) {
            Child child;
            Polygon polygon;
            SurfaceProperty property = (SurfaceProperty)iterator.next();
            AbstractGeometry abstractGeometry = property.getObject();
            if (abstractGeometry instanceof Polygon && (polygon = (Polygon)abstractGeometry).getExterior() != null && (child = polygon.getExterior().getObject()) instanceof LinearRing) {
                LinearRing linearRing = (LinearRing)child;
                if (linearRing.getControlPoints() != null && linearRing.getControlPoints().isSetPosList() && linearRing.getControlPoints().getPosList().getValue().size() == 12) {
                    triangles.getObjects().add(new Triangle((AbstractRing)polygon.getExterior().getObject()));
                } else {
                    return null;
                }
            }
            iterator.remove();
        }
        if (triangles.isSetObjects()) {
            TriangulatedSurface triangulatedSurface = new TriangulatedSurface(triangles);
            triangulatedSurface.setId(compositeSurface.getId());
            return triangulatedSurface;
        }
        return null;
    }

    private void addAppearances(TINRelief object, List<Appearance> appearances, String target) {
        for (Appearance appearance : appearances) {
            Iterator iterator = appearance.getSurfaceData().iterator();
            while (iterator.hasNext()) {
                TextureAssociation association;
                ParameterizedTexture texture;
                X3DMaterial material;
                AbstractSurfaceData surfaceData = (AbstractSurfaceData)((AbstractSurfaceDataProperty)iterator.next()).getObject();
                if (surfaceData instanceof X3DMaterial ? (material = (X3DMaterial)surfaceData).getTargets().size() == 1 && ((GeometryReference)material.getTargets().get(0)).getHref().equals(target) : surfaceData instanceof ParameterizedTexture && (texture = (ParameterizedTexture)surfaceData).getTextureParameterizations().size() == 1 && (association = (TextureAssociation)((TextureAssociationProperty)texture.getTextureParameterizations().get(0)).getObject()) != null && association.getTarget() != null && association.getTarget().getHref().equals(target)) continue;
                iterator.remove();
            }
            if (!appearance.isSetSurfaceData()) continue;
            object.getAppearances().add(new AbstractAppearanceProperty((AbstractAppearance)appearance));
        }
    }
}

