/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceInfo;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.TexCoordList;
import org.citygml4j.core.model.appearance.TextureAssociation;
import org.citygml4j.core.model.appearance.TextureCoordinates;
import org.citygml4j.core.util.reference.Referees;
import org.xmlobjects.gml.model.geometry.compact.AbstractSimplePolygon;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRing;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRingProperty;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.PolygonPatch;
import org.xmlobjects.model.Child;

public class TextureBuilder {
    private final AppearanceSerializer appearanceSerializer;
    private final CityJSONSerializerHelper helper;
    private final Map<String, ObjectNode> textures = new HashMap<String, ObjectNode>();

    TextureBuilder(AppearanceSerializer appearanceSerializer, CityJSONSerializerHelper helper) {
        this.appearanceSerializer = appearanceSerializer;
        this.helper = helper;
    }

    void addTextures(Polygon polygon, boolean reverse, int index) {
        this.addTextures(polygon.getExterior(), polygon.isSetInterior() ? polygon.getInterior() : null, reverse, index);
    }

    void addTextures(PolygonPatch polygonPatch, boolean reverse, int index) {
        this.addTextures(polygonPatch.getExterior(), polygonPatch.isSetInterior() ? polygonPatch.getInterior() : null, reverse, index);
    }

    void addTextures(LinearRing linearRing, boolean reverse, int index) {
        this.addTextures(this.createTexturesCoordinates((AbstractRing)linearRing, reverse), index);
    }

    void addTextures(AbstractSimplePolygon simplePolygon, boolean reverse, int index) {
        Referees referees;
        Referees referees2 = referees = simplePolygon.hasLocalProperties() ? (Referees)simplePolygon.getLocalProperties().get(Referees.PROPERTY_NAME, Referees.class) : null;
        if (referees != null) {
            ArrayList coordinates = new ArrayList();
            for (TextureAssociation association : referees.get(TextureAssociation.class)) {
                TexCoordList texCoordList;
                Child child;
                if (association.getTextureParameterization() == null || !((child = association.getTextureParameterization().getObject()) instanceof TexCoordList) || !(texCoordList = (TexCoordList)child).isSetTextureCoordinates()) continue;
                coordinates.addAll(texCoordList.getTextureCoordinates());
            }
            if (!coordinates.isEmpty()) {
                LinearRing linearRing = new LinearRing();
                linearRing.getLocalProperties().set(Referees.PROPERTY_NAME, (Object)new Referees(coordinates));
                this.addTextures(this.createTexturesCoordinates((AbstractRing)linearRing, reverse), index);
            }
        }
    }

    ObjectNode build(int index) {
        if (!this.textures.isEmpty()) {
            ObjectNode texture = this.helper.createObject();
            for (Map.Entry<String, ObjectNode> entry : this.textures.entrySet()) {
                ObjectNode node = entry.getValue();
                this.appendNullValues((ArrayNode)node.get("values"), index);
                texture.set(entry.getKey(), (JsonNode)node);
            }
            return texture;
        }
        return null;
    }

    private void addTextures(AbstractRingProperty exterior, List<AbstractRingProperty> interior, boolean reverse, int index) {
        Map<String, List<List<Integer>>> indexes = null;
        if (exterior != null && exterior.getObject() != null && (indexes = this.createTexturesCoordinates((AbstractRing)exterior.getObject(), reverse)) != null && interior != null) {
            for (AbstractRingProperty property : interior) {
                if (property.getObject() == null) continue;
                this.createTexturesCoordinates((AbstractRing)property.getObject(), reverse, indexes);
            }
        }
        this.addTextures(indexes, index);
    }

    private Map<String, List<List<Integer>>> createTexturesCoordinates(AbstractRing ring, boolean reverse) {
        return this.createTexturesCoordinates(ring, reverse, null);
    }

    private Map<String, List<List<Integer>>> createTexturesCoordinates(AbstractRing ring, boolean reverse, Map<String, List<List<Integer>>> indexes) {
        Referees referees;
        Referees referees2 = referees = ring.hasLocalProperties() ? (Referees)ring.getLocalProperties().get(Referees.PROPERTY_NAME, Referees.class) : null;
        if (referees != null) {
            HashMap<String, AppearanceInfo> textureInfos = null;
            for (TextureCoordinates textureCoordinates : referees.get(TextureCoordinates.class)) {
                AppearanceInfo textureInfo;
                ParameterizedTexture texture = (ParameterizedTexture)textureCoordinates.getParent(ParameterizedTexture.class);
                if (texture == null || texture.getIsFront() == reverse || !textureCoordinates.isSetValue() || (textureInfo = this.appearanceSerializer.getOrCreateTexture(texture)) == null) continue;
                if (textureInfos == null) {
                    textureInfos = new HashMap<String, AppearanceInfo>();
                }
                if (indexes == null) {
                    indexes = new HashMap<String, List<List<Integer>>>();
                }
                if (textureInfos.putIfAbsent(textureInfo.getTheme(), textureInfo) != null) continue;
                List value = textureCoordinates.getValue();
                int size = value.size();
                if (size > 3 && ((Double)value.get(0)).equals(value.get(size - 2)) && ((Double)value.get(1)).equals(value.get(size - 1))) {
                    value = value.subList(0, value.size() - 2);
                }
                ArrayList<Integer> element = new ArrayList<Integer>();
                element.add(textureInfo.getIndex());
                element.addAll(this.appearanceSerializer.getTextureVerticesBuilder().addTextureVertices(value));
                indexes.computeIfAbsent(textureInfo.getTheme(), v -> new ArrayList()).add(element);
            }
        }
        return indexes;
    }

    private void addTextures(Map<String, List<List<Integer>>> indexes, int index) {
        if (indexes != null) {
            for (Map.Entry<String, List<List<Integer>>> entry : indexes.entrySet()) {
                ObjectNode texture = this.textures.get(entry.getKey());
                if (texture == null) {
                    texture = this.helper.createObject();
                    texture.putArray("values");
                    this.textures.put(entry.getKey(), texture);
                }
                ArrayNode values = (ArrayNode)texture.get("values");
                this.appendNullValues(values, index);
                ArrayNode surface = values.addArray();
                for (List<Integer> element : entry.getValue()) {
                    ArrayNode ring = surface.addArray();
                    element.forEach(arg_0 -> ((ArrayNode)ring).add(arg_0));
                }
            }
        }
    }

    private void appendNullValues(ArrayNode values, int index) {
        while (values.size() < index) {
            ArrayNode surface = values.addArray();
            ArrayNode ring = surface.addArray();
            ring.addNull();
        }
    }
}

