/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.citygml4j.cityjson.adapter.geometry.MultiCurveProvider;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.model.core.ExtendedSpaceGeometry;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.common.GeometryInfo;
import org.citygml4j.core.model.construction.AbstractFillingSurface;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.visitor.ObjectVisitor;
import org.citygml4j.core.visitor.ObjectWalker;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurve;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurveProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.compact.AbstractSimplePolygon;
import org.xmlobjects.gml.model.geometry.primitives.AbstractCurve;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.Curve;
import org.xmlobjects.gml.model.geometry.primitives.CurveProperty;
import org.xmlobjects.gml.model.geometry.primitives.LineString;
import org.xmlobjects.gml.model.geometry.primitives.OrientableCurve;
import org.xmlobjects.gml.model.geometry.primitives.OrientableSurface;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.Surface;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;
import org.xmlobjects.model.Child;

public class SpaceGeometryBuilder {
    private final BoundaryGeometryFinder finder = new BoundaryGeometryFinder();
    private Map<Integer, MultiSurfaceProvider> multiSurfaceProviders;
    private Map<Integer, MultiCurveProvider> multiCurveProviders;

    private SpaceGeometryBuilder() {
    }

    public static SpaceGeometryBuilder newInstance() {
        return new SpaceGeometryBuilder();
    }

    public SpaceGeometryBuilder withMultiSurfaceProviders(Map<Integer, MultiSurfaceProvider> providers) {
        this.multiSurfaceProviders = providers;
        return this;
    }

    public SpaceGeometryBuilder withMultiCurveProviders(Map<Integer, MultiCurveProvider> providers) {
        this.multiCurveProviders = providers;
        return this;
    }

    public void addUnreferencedBoundaryGeometries(AbstractSpace space) {
        this.collectSpaceGeometries(space);
        this.findUnreferencedBoundaryGeometries(space);
        this.addUnreferencedSurfaceGeometries(space);
        this.addUnreferencedCurveGeometries(space);
    }

    private void collectSpaceGeometries(AbstractSpace space) {
        SpaceGeometryCollector collector = new SpaceGeometryCollector();
        GeometryInfo geometryInfo = space.getGeometryInfo();
        Iterator iterator = geometryInfo.getLods().iterator();
        while (iterator.hasNext()) {
            int lod;
            collector.lod = lod = ((Integer)iterator.next()).intValue();
            for (GeometryProperty property : geometryInfo.getGeometries(lod)) {
                collector.visit(property);
            }
        }
    }

    private void findUnreferencedBoundaryGeometries(AbstractSpace space) {
        if (space.isSetBoundaries()) {
            for (AbstractSpaceBoundaryProperty property : space.getBoundaries()) {
                if (property.getObject() == null) continue;
                AbstractSpaceBoundary boundary = (AbstractSpaceBoundary)property.getObject();
                this.processSemanticSurface(boundary);
                boundary.accept((ObjectVisitor)new ObjectWalker(){

                    public void visit(AbstractFillingSurface fillingSurface) {
                        SpaceGeometryBuilder.this.processSemanticSurface((AbstractSpaceBoundary)fillingSurface);
                    }
                });
            }
        }
    }

    private void processSemanticSurface(AbstractSpaceBoundary semanticSurface) {
        this.finder.semanticSurface = semanticSurface;
        GeometryInfo geometryInfo = semanticSurface.getGeometryInfo();
        Iterator iterator = geometryInfo.getLods().iterator();
        while (iterator.hasNext()) {
            int lod;
            this.finder.lod = lod = ((Integer)iterator.next()).intValue();
            for (GeometryProperty geometryProperty : geometryInfo.getGeometries(lod)) {
                this.finder.visit(geometryProperty);
            }
        }
    }

    private void addUnreferencedSurfaceGeometries(AbstractSpace space) {
        for (Map.Entry<Integer, List<AbstractSurface>> entry : this.finder.surfaces.entrySet()) {
            MultiSurfaceProvider provider;
            MultiSurface multiSurface = null;
            MultiSurfaceProvider multiSurfaceProvider = provider = this.multiSurfaceProviders != null ? this.multiSurfaceProviders.get(entry.getKey()) : null;
            if (provider != null) {
                multiSurface = this.getOrSetMultiSurface(provider.get(), provider::set);
            } else {
                switch (entry.getKey()) {
                    case 0: {
                        multiSurface = this.getOrSetMultiSurface(space.getLod0MultiSurface(), arg_0 -> ((AbstractSpace)space).setLod0MultiSurface(arg_0));
                        break;
                    }
                    case 1: {
                        ExtendedSpaceGeometry geometry = new ExtendedSpaceGeometry();
                        multiSurface = this.getOrSetMultiSurface(geometry.getLod1MultiSurface(), geometry::setLod1MultiSurface);
                        space.addADEProperty((ADEProperty)geometry);
                        break;
                    }
                    case 2: {
                        multiSurface = this.getOrSetMultiSurface(space.getLod2MultiSurface(), arg_0 -> ((AbstractSpace)space).setLod2MultiSurface(arg_0));
                        break;
                    }
                    case 3: {
                        multiSurface = this.getOrSetMultiSurface(space.getLod3MultiSurface(), arg_0 -> ((AbstractSpace)space).setLod3MultiSurface(arg_0));
                    }
                }
            }
            if (multiSurface == null) continue;
            for (AbstractSurface surface : entry.getValue()) {
                SurfaceProperty property = this.decorate(new SurfaceProperty());
                property.setReferencedObject((Child)surface, false);
                multiSurface.getSurfaceMember().add(property);
            }
        }
    }

    private void addUnreferencedCurveGeometries(AbstractSpace space) {
        for (Map.Entry<Integer, List<AbstractCurve>> entry : this.finder.curves.entrySet()) {
            MultiCurve multiCurve;
            MultiCurveProvider provider;
            MultiCurveProvider multiCurveProvider = provider = this.multiCurveProviders != null ? this.multiCurveProviders.get(entry.getKey()) : null;
            if (provider != null) {
                multiCurve = this.getOrSetMultiCurve(provider.get(), provider::set);
            } else {
                switch (entry.getKey()) {
                    case 0: {
                        MultiCurve multiCurve2 = this.getOrSetMultiCurve(space.getLod0MultiCurve(), arg_0 -> ((AbstractSpace)space).setLod0MultiCurve(arg_0));
                        break;
                    }
                    case 2: {
                        MultiCurve multiCurve2 = this.getOrSetMultiCurve(space.getLod2MultiCurve(), arg_0 -> ((AbstractSpace)space).setLod2MultiCurve(arg_0));
                        break;
                    }
                    case 3: {
                        MultiCurve multiCurve2 = this.getOrSetMultiCurve(space.getLod3MultiCurve(), arg_0 -> ((AbstractSpace)space).setLod3MultiCurve(arg_0));
                        break;
                    }
                    default: {
                        MultiCurve multiCurve2 = multiCurve = null;
                    }
                }
            }
            if (multiCurve == null) continue;
            for (AbstractCurve curve : entry.getValue()) {
                CurveProperty property = this.decorate(new CurveProperty());
                property.setReferencedObject((Child)curve, false);
                multiCurve.getCurveMember().add(property);
            }
        }
    }

    private MultiSurface getOrSetMultiSurface(MultiSurfaceProperty property, Consumer<MultiSurfaceProperty> consumer) {
        if (property == null || property.getObject() == null) {
            property = this.decorate(new MultiSurfaceProperty(new MultiSurface()));
            consumer.accept(property);
        }
        return (MultiSurface)property.getObject();
    }

    private MultiCurve getOrSetMultiCurve(MultiCurveProperty property, Consumer<MultiCurveProperty> consumer) {
        if (property == null || property.getObject() == null) {
            property = this.decorate(new MultiCurveProperty(new MultiCurve()));
            consumer.accept(property);
        }
        return (MultiCurve)property.getObject();
    }

    private <T extends GeometryProperty<?>> T decorate(T property) {
        property.getLocalProperties().set("org.citygml4j.tempObject", (Object)true);
        return property;
    }

    private <T extends AbstractGeometry> T decorate(T geometry, AbstractSpaceBoundary semanticSurface) {
        geometry.getLocalProperties().set("org.citygml4j.cityjson.semanticSurface", (Object)semanticSurface);
        return geometry;
    }

    public void removeTemporaryInformation(AbstractSpace space) {
        block6: for (int lod = 0; lod < 4; ++lod) {
            switch (lod) {
                case 0: {
                    this.removeTemporaryGeometries(space.getLod0MultiSurface(), arg_0 -> ((AbstractSpace)space).setLod0MultiSurface(arg_0));
                    this.removeTemporaryGeometries(space.getLod0MultiCurve(), arg_0 -> ((AbstractSpace)space).setLod0MultiCurve(arg_0));
                    continue block6;
                }
                case 1: {
                    if (!space.hasADEProperties()) continue block6;
                    space.getADEProperties().removeIf(ExtendedSpaceGeometry.class::isInstance);
                    if (space.hasADEProperties()) continue block6;
                    space.setADEProperties(null);
                    continue block6;
                }
                case 2: {
                    this.removeTemporaryGeometries(space.getLod2MultiSurface(), arg_0 -> ((AbstractSpace)space).setLod2MultiSurface(arg_0));
                    this.removeTemporaryGeometries(space.getLod2MultiCurve(), arg_0 -> ((AbstractSpace)space).setLod2MultiCurve(arg_0));
                    continue block6;
                }
                case 3: {
                    this.removeTemporaryGeometries(space.getLod3MultiSurface(), arg_0 -> ((AbstractSpace)space).setLod3MultiSurface(arg_0));
                    this.removeTemporaryGeometries(space.getLod3MultiCurve(), arg_0 -> ((AbstractSpace)space).setLod3MultiCurve(arg_0));
                }
            }
        }
        if (this.multiSurfaceProviders != null) {
            for (MultiSurfaceProvider multiSurfaceProvider : this.multiSurfaceProviders.values()) {
                this.removeTemporaryGeometries(multiSurfaceProvider.get(), multiSurfaceProvider::set);
            }
        }
        if (this.multiCurveProviders != null) {
            for (MultiCurveProvider multiCurveProvider : this.multiCurveProviders.values()) {
                this.removeTemporaryGeometries(multiCurveProvider.get(), multiCurveProvider::set);
            }
        }
        for (Map<Integer, AbstractGeometry> map : this.finder.spaceGeometries.values()) {
            this.removeTemporarySemanticSurfaces(map.values());
        }
        for (Collection collection : this.finder.surfaces.values()) {
            this.removeTemporarySemanticSurfaces(collection);
        }
        for (Collection collection : this.finder.curves.values()) {
            this.removeTemporarySemanticSurfaces(collection);
        }
    }

    private void removeTemporaryGeometries(MultiSurfaceProperty property, Consumer<MultiSurfaceProperty> consumer) {
        if (property != null) {
            if (this.isTemporaryGeometry((GeometryProperty<?>)property)) {
                consumer.accept(null);
            } else if (property.getObject() != null && ((MultiSurface)property.getObject()).isSetSurfaceMember()) {
                ((MultiSurface)property.getObject()).getSurfaceMember().removeIf(this::isTemporaryGeometry);
            }
        }
    }

    private void removeTemporaryGeometries(MultiCurveProperty property, Consumer<MultiCurveProperty> consumer) {
        if (property != null) {
            if (this.isTemporaryGeometry((GeometryProperty<?>)property)) {
                consumer.accept(null);
            } else if (property.getObject() != null && ((MultiCurve)property.getObject()).isSetCurveMember()) {
                ((MultiCurve)property.getObject()).getCurveMember().removeIf(this::isTemporaryGeometry);
            }
        }
    }

    private boolean isTemporaryGeometry(GeometryProperty<?> property) {
        return property != null && property.hasLocalProperties() && property.getLocalProperties().contains("org.citygml4j.tempObject");
    }

    private void removeTemporarySemanticSurfaces(Collection<? extends AbstractGeometry> geometries) {
        for (AbstractGeometry abstractGeometry : geometries) {
            if (!abstractGeometry.hasLocalProperties()) continue;
            abstractGeometry.getLocalProperties().remove("org.citygml4j.cityjson.semanticSurface");
            if (!abstractGeometry.getLocalProperties().isEmpty()) continue;
            abstractGeometry.setLocalProperties(null);
        }
    }

    private final class BoundaryGeometryFinder
    extends ObjectWalker {
        final Map<String, Map<Integer, AbstractGeometry>> spaceGeometries = new HashMap<String, Map<Integer, AbstractGeometry>>();
        final Map<Integer, List<AbstractSurface>> surfaces = new HashMap<Integer, List<AbstractSurface>>();
        final Map<Integer, List<AbstractCurve>> curves = new HashMap<Integer, List<AbstractCurve>>();
        AbstractSpaceBoundary semanticSurface;
        int lod;

        private BoundaryGeometryFinder() {
        }

        public void visit(Polygon polygon) {
            this.addSurface((AbstractSurface)polygon);
        }

        public void visit(AbstractSimplePolygon simplePolygon) {
            this.addSurface((AbstractSurface)simplePolygon);
        }

        public void visit(OrientableSurface orientableSurface) {
            this.addSurface((AbstractSurface)orientableSurface);
        }

        public void visit(Surface surface) {
            this.addSurface((AbstractSurface)surface);
        }

        public void visit(LineString lineString) {
            this.addCurve((AbstractCurve)lineString);
        }

        public void visit(OrientableCurve orientableCurve) {
            this.addCurve((AbstractCurve)orientableCurve);
        }

        public void visit(Curve curve) {
            this.addCurve((AbstractCurve)curve);
        }

        private void addSurface(AbstractSurface surface) {
            if (this.isNotReferenced((Child)surface)) {
                this.surfaces.computeIfAbsent(this.lod, v -> new ArrayList()).add(SpaceGeometryBuilder.this.decorate(surface, this.semanticSurface));
            }
        }

        private void addCurve(AbstractCurve curve) {
            if (this.isNotReferenced((Child)curve)) {
                this.curves.computeIfAbsent(this.lod, v -> new ArrayList()).add(SpaceGeometryBuilder.this.decorate(curve, this.semanticSurface));
            }
        }

        private boolean isNotReferenced(Child child) {
            do {
                AbstractGeometry spaceGeometry;
                AbstractGeometry geometry;
                if (!(child instanceof AbstractGeometry) || (geometry = (AbstractGeometry)child).getId() == null || (spaceGeometry = (AbstractGeometry)this.spaceGeometries.getOrDefault(geometry.getId(), Collections.emptyMap()).get(this.lod)) == null) continue;
                SpaceGeometryBuilder.this.decorate(spaceGeometry, this.semanticSurface);
                return false;
            } while ((child = child.getParent()) != null && !(child instanceof AbstractFeature));
            return true;
        }
    }

    private final class SpaceGeometryCollector
    extends ObjectWalker {
        int lod;

        private SpaceGeometryCollector() {
        }

        public void visit(AbstractGeometry geometry) {
            if (geometry.getId() != null) {
                SpaceGeometryBuilder.this.finder.spaceGeometries.computeIfAbsent(geometry.getId(), v -> new HashMap()).put(this.lod, geometry);
                AbstractFeature parent = (AbstractFeature)geometry.getParent(AbstractFeature.class);
                if (parent instanceof AbstractSpaceBoundary) {
                    AbstractSpaceBoundary boundary = (AbstractSpaceBoundary)parent;
                    SpaceGeometryBuilder.this.decorate(geometry, boundary);
                }
            }
        }
    }
}

