/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;

public class SemanticsBuilder {
    private final CityJSONSerializerHelper helper;
    private final Map<AbstractSpaceBoundary, Integer> boundaries = new IdentityHashMap<AbstractSpaceBoundary, Integer>();
    private final List<ObjectNode> surfaces = new ArrayList<ObjectNode>();
    private final ArrayNode values;

    SemanticsBuilder(CityJSONSerializerHelper helper) {
        this.helper = helper;
        this.values = helper.createArray();
    }

    void addSemantics(AbstractGeometry geometry, int index) {
        AbstractSpaceBoundary boundary = null;
        do {
            if (!geometry.hasLocalProperties()) continue;
            boundary = (AbstractSpaceBoundary)geometry.getLocalProperties().get("org.citygml4j.cityjson.semanticSurface", AbstractSpaceBoundary.class);
        } while (boundary == null && (geometry = (AbstractGeometry)geometry.getParent(AbstractGeometry.class)) != null);
        if (boundary != null) {
            Integer value = this.boundaries.get(boundary);
            if (value == null) {
                ObjectNode surface = null;
                try {
                    surface = this.helper.getObject(boundary);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (surface != null) {
                    value = this.surfaces.size();
                    this.surfaces.add(surface);
                } else {
                    value = -1;
                }
                this.boundaries.put(boundary, value);
            }
            if (value != -1) {
                this.appendNullValues(index);
                this.values.add(value);
            }
        }
    }

    ObjectNode build(int index) {
        if (!this.surfaces.isEmpty()) {
            block0: for (Map.Entry<AbstractSpaceBoundary, Integer> entry : this.boundaries.entrySet()) {
                if (entry.getValue() == -1) continue;
                AbstractSpaceBoundary parent = entry.getKey();
                while ((parent = (AbstractSpaceBoundary)parent.getParent(AbstractSpaceBoundary.class)) != null) {
                    Integer parentIndex = this.boundaries.get(parent);
                    if (parentIndex == null) continue;
                    this.surfaces.get(entry.getValue()).put("parent", parentIndex);
                    this.helper.getOrPutArray("children", this.surfaces.get(parentIndex)).add(entry.getValue());
                    continue block0;
                }
            }
            this.appendNullValues(index);
            ObjectNode semantics = this.helper.createObject();
            semantics.putArray("surfaces").addAll(this.surfaces);
            semantics.set("values", (JsonNode)this.values);
            return semantics;
        }
        return null;
    }

    private void appendNullValues(int index) {
        while (this.values.size() < index) {
            this.values.addNull();
        }
    }
}

