/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.EnumSet;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.geometry.serializer.CurveGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.PointGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.SolidGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.SurfaceGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.compact.AbstractSimplePolygon;
import org.xmlobjects.gml.model.geometry.compact.SimpleMultiPoint;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSolid;
import org.xmlobjects.gml.model.geometry.primitives.Curve;
import org.xmlobjects.gml.model.geometry.primitives.LineString;
import org.xmlobjects.gml.model.geometry.primitives.OrientableCurve;
import org.xmlobjects.gml.model.geometry.primitives.OrientableSurface;
import org.xmlobjects.gml.model.geometry.primitives.Point;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.Solid;
import org.xmlobjects.gml.model.geometry.primitives.Surface;
import org.xmlobjects.gml.visitor.GeometryVisitor;

public class MultiGeometryBuilder
extends GeometryBuilder {
    private final EnumSet<GeometryType> allowedTypes;
    private final AppearanceSerializer appearanceSerializer;
    private final VerticesBuilder verticesBuilder;
    private GeometryBuilder pointGeometryBuilder;
    private GeometryBuilder curveGeometryBuilder;
    private GeometryBuilder surfaceGeometryBuilder;
    private GeometryBuilder solidGeometryBuilder;

    MultiGeometryBuilder(EnumSet<GeometryType> allowedTypes, AppearanceSerializer appearanceSerializer, VerticesBuilder verticesBuilder, CityJSONSerializerHelper helper) {
        super(helper);
        this.allowedTypes = allowedTypes;
        this.appearanceSerializer = appearanceSerializer;
        this.verticesBuilder = verticesBuilder;
    }

    ArrayNode build(AbstractGeometry geometry, Number lod) {
        ArrayNode node = this.helper.createArray();
        this.build(geometry, lod, node);
        return node;
    }

    void build(AbstractGeometry geometry, Number lod, ArrayNode node) {
        this.build(geometry, lod, this.pointGeometryBuilder, node);
        this.build(geometry, lod, this.curveGeometryBuilder, node);
        this.build(geometry, lod, this.surfaceGeometryBuilder, node);
        this.build(geometry, lod, this.solidGeometryBuilder, node);
    }

    private void build(AbstractGeometry geometry, Number lod, GeometryBuilder builder, ArrayNode node) {
        JsonNode geometryNode;
        if (builder != null && (geometryNode = builder.build(geometry, lod)) != null) {
            node.add(geometryNode);
        }
    }

    @Override
    int size() {
        return (this.pointGeometryBuilder != null ? this.pointGeometryBuilder.size() : 0) + (this.curveGeometryBuilder != null ? this.curveGeometryBuilder.size() : 0) + (this.surfaceGeometryBuilder != null ? this.surfaceGeometryBuilder.size() : 0) + (this.solidGeometryBuilder != null ? this.solidGeometryBuilder.size() : 0);
    }

    public void visit(Point point) {
        point.accept((GeometryVisitor)this.getOrCreatePointGeometryBuilder());
    }

    public void visit(SimpleMultiPoint simpleMultiPoint) {
        simpleMultiPoint.accept((GeometryVisitor)this.getOrCreatePointGeometryBuilder());
    }

    public void visit(Curve curve) {
        curve.accept((GeometryVisitor)this.getOrCreateCurveGeometryBuilder());
    }

    public void visit(LineString lineString) {
        lineString.accept((GeometryVisitor)this.getOrCreateCurveGeometryBuilder());
    }

    public void visit(OrientableCurve orientableCurve) {
        orientableCurve.accept((GeometryVisitor)this.getOrCreateCurveGeometryBuilder());
    }

    public void visit(Polygon polygon) {
        polygon.accept((GeometryVisitor)this.getOrCreateSurfaceGeometryBuilder());
    }

    public void visit(AbstractSimplePolygon simplePolygon) {
        simplePolygon.accept((GeometryVisitor)this.getOrCreateSurfaceGeometryBuilder());
    }

    public void visit(Surface surface) {
        surface.accept((GeometryVisitor)this.getOrCreateSurfaceGeometryBuilder());
    }

    public void visit(OrientableSurface orientableSurface) {
        orientableSurface.accept((GeometryVisitor)this.getOrCreateSurfaceGeometryBuilder());
    }

    public void visit(MultiSurface multiSurface) {
        multiSurface.accept((GeometryVisitor)this.getOrCreateSurfaceGeometryBuilder());
    }

    public void visit(Solid solid) {
        solid.accept((GeometryVisitor)this.getOrCreateSolidGeometryBuilder());
    }

    public void visit(CompositeSolid compositeSolid) {
        compositeSolid.accept((GeometryVisitor)this.getOrCreateSolidGeometryBuilder());
    }

    private GeometryBuilder getOrCreatePointGeometryBuilder() {
        if (this.pointGeometryBuilder == null) {
            this.pointGeometryBuilder = new PointGeometryBuilder(this.allowedTypes, this.verticesBuilder, this.helper);
        }
        return this.pointGeometryBuilder;
    }

    private GeometryBuilder getOrCreateCurveGeometryBuilder() {
        if (this.curveGeometryBuilder == null) {
            this.curveGeometryBuilder = new CurveGeometryBuilder(this.allowedTypes, this.verticesBuilder, this.helper);
        }
        return this.curveGeometryBuilder;
    }

    private GeometryBuilder getOrCreateSurfaceGeometryBuilder() {
        if (this.surfaceGeometryBuilder == null) {
            this.surfaceGeometryBuilder = new SurfaceGeometryBuilder(this.allowedTypes, this.appearanceSerializer, this.verticesBuilder, this.helper);
        }
        return this.surfaceGeometryBuilder;
    }

    private GeometryBuilder getOrCreateSolidGeometryBuilder() {
        if (this.solidGeometryBuilder == null) {
            this.solidGeometryBuilder = new SolidGeometryBuilder(this.allowedTypes, this.appearanceSerializer, this.verticesBuilder, this.helper);
        }
        return this.solidGeometryBuilder;
    }
}

