/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceInfo;
import org.citygml4j.core.model.appearance.Appearance;

public class TemplateInfo {
    private final ArrayNode templates;
    private Map<Integer, String> references;
    private Map<String, Set<String>> localAppearances;
    private AppearanceInfo appearanceInfo;

    TemplateInfo(ArrayNode templates) {
        this.templates = templates;
    }

    JsonNode getTemplate(int index) {
        return this.templates.path(index);
    }

    String getReference(int index) {
        return this.references != null ? this.references.get(index) : null;
    }

    void addReference(int index, String reference) {
        if (this.references == null) {
            this.references = new HashMap<Integer, String>();
        }
        this.references.put(index, reference);
    }

    Set<String> getLocalAppearances(String reference) {
        return this.localAppearances != null ? this.localAppearances.getOrDefault(reference, Collections.emptySet()) : Collections.emptySet();
    }

    void addLocalAppearance(String reference, String localAppearance) {
        if (this.localAppearances == null) {
            this.localAppearances = new HashMap<String, Set<String>>();
        }
        this.localAppearances.computeIfAbsent(reference, v -> new HashSet()).add(localAppearance);
    }

    List<Appearance> getGlobalAppearances() {
        return this.hasGlobalAppearances() ? this.appearanceInfo.getAppearances() : Collections.emptyList();
    }

    boolean hasGlobalAppearances() {
        return this.appearanceInfo != null && this.appearanceInfo.hasAppearances();
    }

    AppearanceInfo getAppearanceInfo() {
        if (this.appearanceInfo == null) {
            this.appearanceInfo = new AppearanceInfo();
        }
        return this.appearanceInfo;
    }
}

