/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.citygml4j.cityjson.adapter.generics.GenericThematicSurfaceAdapter;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.core.model.construction.AbstractConstructionSurface;
import org.citygml4j.core.model.construction.AbstractFillingSurface;
import org.citygml4j.core.model.construction.AbstractFillingSurfaceProperty;
import org.citygml4j.core.model.construction.CeilingSurface;
import org.citygml4j.core.model.construction.DoorSurface;
import org.citygml4j.core.model.construction.FloorSurface;
import org.citygml4j.core.model.construction.InteriorWallSurface;
import org.citygml4j.core.model.construction.WindowSurface;
import org.citygml4j.core.model.core.AbstractGenericAttribute;
import org.citygml4j.core.model.core.AbstractGenericAttributeProperty;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.citygml4j.core.model.core.AbstractThematicSurface;
import org.citygml4j.core.model.generics.GenericThematicSurface;
import org.citygml4j.core.model.generics.StringAttribute;
import org.citygml4j.core.model.transportation.HoleSurface;
import org.citygml4j.core.model.transportation.Marking;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;
import org.xmlobjects.util.copy.CopyBuilder;

public class SemanticsBuilder {
    private final CityJSONBuilderHelper helper;
    private CopyBuilder copyBuilder;

    SemanticsBuilder(CityJSONBuilderHelper helper) {
        this.helper = helper;
    }

    void build(AbstractSpace object, JsonNode node, BoundaryFilter filter, List<SurfaceProperty> geometries, int lod, GeometryObject geometryObject) {
        JsonNode values = node.path("values");
        JsonNode surfaces = node.path("surfaces");
        if (!values.isArray() || !surfaces.isArray()) {
            return;
        }
        if (filter == null) {
            filter = arg_0 -> ((AbstractSpace)object).isValidBoundary(arg_0);
        }
        HashMap<Integer, AbstractThematicSurface> boundaries = new HashMap<Integer, AbstractThematicSurface>();
        this.createBoundaries((ArrayNode)surfaces, boundaries, filter);
        this.assignGeometries(boundaries, (ArrayNode)values, geometries, lod);
        this.rebuildHierarchies((ArrayNode)surfaces, boundaries);
        this.cleanupBoundaries((ArrayNode)surfaces, filter, boundaries);
        if (!boundaries.isEmpty()) {
            geometryObject.setBoundaries(new ArrayList<AbstractSpaceBoundary>(boundaries.values()));
        }
    }

    private void createBoundaries(ArrayNode surfaces, Map<Integer, AbstractThematicSurface> boundaries, BoundaryFilter filter) {
        for (int i = 0; i < surfaces.size(); ++i) {
            try {
                JsonNode surface = surfaces.get(i);
                String type = surface.path("type").asText();
                AbstractThematicSurface boundary = this.helper.getObject(type, surface, AbstractThematicSurface.class);
                if (boundary == null && this.helper.isMapUnsupportedTypesToGenerics() && filter.isValidBoundary(GenericThematicSurface.class)) {
                    boundary = (AbstractThematicSurface)this.helper.getObjectUsingBuilder(surface, GenericThematicSurfaceAdapter.class);
                    this.addGenericTypeAttribute(type, boundary);
                }
                if (boundary == null) continue;
                boundaries.put(i, boundary);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void rebuildHierarchies(ArrayNode surfaces, Map<Integer, AbstractThematicSurface> boundaries) {
        for (int i = 0; i < surfaces.size(); ++i) {
            JsonNode surface = surfaces.get(i);
            AbstractThematicSurface boundary = boundaries.get(i);
            if (boundary instanceof AbstractConstructionSurface) {
                AbstractConstructionSurface constructionSurface = (AbstractConstructionSurface)boundary;
                for (JsonNode element : surface.path("children")) {
                    int index = element.asInt(-1);
                    AbstractThematicSurface child = boundaries.get(index);
                    if (!(child instanceof AbstractFillingSurface)) continue;
                    AbstractFillingSurface fillingSurface = (AbstractFillingSurface)child;
                    constructionSurface.getFillingSurfaces().add(new AbstractFillingSurfaceProperty(fillingSurface));
                    boundaries.remove(index);
                }
                continue;
            }
            if (!(boundary instanceof AbstractFillingSurface)) continue;
            AbstractFillingSurface fillingSurface = (AbstractFillingSurface)boundary;
            AbstractThematicSurface parent = boundaries.get(surface.path("parent").asInt(-1));
            if (!(parent instanceof AbstractConstructionSurface)) continue;
            AbstractConstructionSurface constructionSurface = (AbstractConstructionSurface)parent;
            constructionSurface.getFillingSurfaces().add(new AbstractFillingSurfaceProperty(fillingSurface));
            boundaries.remove(i);
        }
    }

    private void cleanupBoundaries(ArrayNode surfaces, BoundaryFilter filter, Map<Integer, AbstractThematicSurface> boundaries) {
        List<Map.Entry> entries = boundaries.entrySet().stream().filter(e -> !filter.isValidBoundary((AbstractSpaceBoundary)e.getValue())).collect(Collectors.toList());
        if (!entries.isEmpty()) {
            if (this.helper.isMapUnsupportedTypesToGenerics() && filter.isValidBoundary(GenericThematicSurface.class)) {
                CopyBuilder copyBuilder = this.getOrCreateCopyBuilder();
                for (Map.Entry entry2 : entries) {
                    GenericThematicSurface boundary = new GenericThematicSurface();
                    copyBuilder.shallowCopy((Object)((AbstractThematicSurface)entry2.getValue()), (Object)boundary, AbstractThematicSurface.class);
                    JsonNode surface = surfaces.get(((Integer)entry2.getKey()).intValue());
                    this.addGenericTypeAttribute(surface.path("type").asText(), (AbstractThematicSurface)boundary);
                    entry2.setValue(boundary);
                }
            } else {
                entries.forEach(entry -> boundaries.remove(entry.getKey()));
            }
        }
    }

    private void assignGeometries(Map<Integer, AbstractThematicSurface> boundaries, ArrayNode values, List<SurfaceProperty> geometries, int lod) {
        List<Integer> flatValues = this.flatValues(values);
        for (int index = 0; index < flatValues.size() && index < geometries.size(); ++index) {
            MultiSurface multiSurface;
            int value = flatValues.get(index);
            AbstractThematicSurface boundary2 = boundaries.get(value);
            if (boundary2 == null || !this.isAvailableForLod(boundary2, lod) || (multiSurface = this.getOrCreateMultiSurface(boundary2, lod)) == null) continue;
            SurfaceProperty property = geometries.get(index);
            multiSurface.getSurfaceMember().add(new SurfaceProperty((AbstractSurface)property.getObject()));
            property.setHref("#" + this.helper.getOrCreateId((AbstractGML)property.getObject()));
            property.setInlineObject(null);
        }
        boundaries.values().removeIf(boundary -> boundary.getMultiSurface(lod) == null);
    }

    private MultiSurface getOrCreateMultiSurface(AbstractThematicSurface boundary, int lod) {
        MultiSurfaceProperty property = boundary.getMultiSurface(lod);
        if (property == null && !boundary.setMultiSurface(lod, property = new MultiSurfaceProperty(new MultiSurface()))) {
            return null;
        }
        return (MultiSurface)property.getObject();
    }

    private boolean isAvailableForLod(AbstractThematicSurface boundary, int lod) {
        if (this.helper.getTargetCityGMLVersion() == CityGMLVersion.v3_0) {
            return lod >= 0 && lod < 4;
        }
        if (boundary instanceof DoorSurface || boundary instanceof WindowSurface || boundary instanceof InteriorWallSurface || boundary instanceof CeilingSurface || boundary instanceof FloorSurface) {
            return lod == 3;
        }
        if (boundary instanceof Marking || boundary instanceof HoleSurface || boundary instanceof GenericThematicSurface) {
            return false;
        }
        return lod >= 2 && lod < 4;
    }

    private List<Integer> flatValues(ArrayNode values) {
        ArrayList<Integer> flatValues = new ArrayList<Integer>();
        this.flatValues(values, flatValues);
        return flatValues;
    }

    private void flatValues(ArrayNode values, List<Integer> flatValues) {
        for (JsonNode value : values) {
            if (value.isArray()) {
                this.flatValues((ArrayNode)value, flatValues);
                continue;
            }
            flatValues.add(value.asInt(-1));
        }
    }

    private void addGenericTypeAttribute(String type, AbstractThematicSurface boundary) {
        if (type.startsWith("+")) {
            type = type.substring(1);
        }
        StringAttribute stringAttribute = new StringAttribute("CityJSONType", type);
        boundary.getGenericAttributes().add(new AbstractGenericAttributeProperty((AbstractGenericAttribute)stringAttribute));
    }

    private CopyBuilder getOrCreateCopyBuilder() {
        if (this.copyBuilder == null) {
            this.copyBuilder = new CopyBuilder();
        }
        return this.copyBuilder;
    }
}

