/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Map;
import org.citygml4j.cityjson.adapter.core.AbstractCityObjectAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiCurveProvider;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.QualifiedArea;
import org.citygml4j.core.model.core.QualifiedVolume;
import org.citygml4j.core.model.core.QualifiedVolumeProperty;
import org.citygml4j.core.model.core.SpaceType;

public abstract class AbstractSpaceAdapter<T extends AbstractSpace>
extends AbstractCityObjectAdapter<T> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.allOf(GeometryType.class);

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        JsonNode spaceType = attributes.consume("spaceType");
        if (spaceType.isTextual()) {
            object.setSpaceType(SpaceType.fromValue((String)spaceType.asText()));
        }
        helper.addGeometries((AbstractSpace)object, node.get("geometry"));
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        if (object.getSpaceType() != null) {
            attributes.put("spaceType", object.getSpaceType().toValue());
        }
        if (object.isSetVolumes()) {
            for (QualifiedVolumeProperty property : object.getVolumes()) {
                if (property.getObject() == null || ((QualifiedVolume)property.getObject()).getVolume() == null) continue;
                attributes.put("volume", ((QualifiedVolume)property.getObject()).getVolume().getValue());
                break;
            }
        }
        if (object.isSetAreas()) {
            for (QualifiedVolumeProperty property : object.getAreas()) {
                if (property.getObject() == null || ((QualifiedArea)property.getObject()).getArea() == null) continue;
                attributes.put("area", ((QualifiedArea)property.getObject()).getArea().getValue());
                break;
            }
        }
        helper.addGeometries((AbstractSpace)object, node, this.getAllowedGeometryTypes(helper.getVersion()));
    }

    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }

    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(T object) {
        return null;
    }

    public Map<Integer, MultiCurveProvider> getMultiCurveProviders(T object) {
        return null;
    }
}

