/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.building;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.core.AbstractUnoccupiedSpaceAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.building.BuildingFurniture;
import org.citygml4j.core.model.building.BuildingFurnitureProperty;
import org.citygml4j.core.model.building.BuildingInstallation;
import org.citygml4j.core.model.building.BuildingInstallationProperty;
import org.citygml4j.core.model.building.BuildingRoom;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.building.DeprecatedPropertiesOfBuildingRoom;

@CityJSONElements(value={@CityJSONElement(name="BuildingRoom", schema="CityJSON-Core", version=CityJSONVersion.v2_0), @CityJSONElement(name="BuildingRoom", schema="CityJSON-Core", version=CityJSONVersion.v1_1)})
public class BuildingRoomAdapter
extends AbstractUnoccupiedSpaceAdapter<BuildingRoom> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID);

    @Override
    public BuildingRoom createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new BuildingRoom();
    }

    @Override
    public void buildObject(BuildingRoom object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        Iterator children = node.path("children").elements();
        block8: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "BuildingInstallation": {
                    object.getBuildingInstallations().add(new BuildingInstallationProperty(helper.getCityObject(child, BuildingInstallation.class)));
                    break;
                }
                case "BuildingFurniture": {
                    object.getBuildingFurniture().add(new BuildingFurnitureProperty(helper.getCityObject(child, BuildingFurniture.class)));
                    break;
                }
                default: {
                    continue block8;
                }
            }
            children.remove();
        }
    }

    @Override
    public String createType(BuildingRoom object, CityJSONVersion version) throws CityJSONSerializeException {
        return "BuildingRoom";
    }

    @Override
    public void writeObject(BuildingRoom object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetBuildingInstallations()) {
            for (BuildingInstallationProperty property : object.getBuildingInstallations()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BuildingInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetBuildingFurniture()) {
            for (BuildingInstallationProperty property : object.getBuildingFurniture()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BuildingFurniture)property.getObject(), (AbstractFeature)object, node);
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(BuildingRoom object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfBuildingRoom properties = object.getDeprecatedProperties();
            return Map.of(4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfBuildingRoom)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfBuildingRoom)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

