/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.building;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.construction.AbstractConstructionAdapter;
import org.citygml4j.cityjson.adapter.core.AddressAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.building.AbstractBuilding;
import org.citygml4j.core.model.building.BuildingConstructiveElement;
import org.citygml4j.core.model.building.BuildingConstructiveElementProperty;
import org.citygml4j.core.model.building.BuildingFurniture;
import org.citygml4j.core.model.building.BuildingFurnitureProperty;
import org.citygml4j.core.model.building.BuildingInstallation;
import org.citygml4j.core.model.building.BuildingInstallationProperty;
import org.citygml4j.core.model.building.BuildingRoom;
import org.citygml4j.core.model.building.BuildingRoomProperty;
import org.citygml4j.core.model.construction.RelationToConstruction;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.Address;
import org.citygml4j.core.model.core.AddressProperty;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.building.DeprecatedPropertiesOfAbstractBuilding;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.basictypes.DoubleOrNilReason;
import org.xmlobjects.gml.model.basictypes.MeasureOrNilReasonList;

public abstract class AbstractBuildingAdapter<T extends AbstractBuilding>
extends AbstractConstructionAdapter<T> {
    private final Map<CityJSONVersion, EnumSet<GeometryType>> allowedTypes = new EnumMap<CityJSONVersion, EnumSet<GeometryType>>(CityJSONVersion.class);

    public AbstractBuildingAdapter() {
        this.allowedTypes.put(CityJSONVersion.v2_0, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
        this.allowedTypes.put(CityJSONVersion.v1_1, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
        this.allowedTypes.put(CityJSONVersion.v1_0, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
    }

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode address;
        JsonNode storeyHeightsBelowGround;
        JsonNode storeyHeightsAboveGround;
        JsonNode storeysBelowGround;
        JsonNode storeysAboveGround;
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        JsonNode roofType = attributes.consume("roofType");
        if (roofType.isTextual()) {
            object.setRoofType(new Code(roofType.asText()));
        }
        if ((storeysAboveGround = attributes.consume("storeysAboveGround")).isInt()) {
            object.setStoreysAboveGround(Integer.valueOf(storeysAboveGround.asInt()));
        }
        if ((storeysBelowGround = attributes.consume("storeysBelowGround")).isInt()) {
            object.setStoreysBelowGround(Integer.valueOf(storeysBelowGround.asInt()));
        }
        if ((storeyHeightsAboveGround = attributes.consume("storeyHeightsAboveGround")).isArray()) {
            MeasureOrNilReasonList measures = new MeasureOrNilReasonList();
            for (Object value : storeyHeightsAboveGround) {
                if (!value.isNumber()) continue;
                measures.getValue().add(new DoubleOrNilReason(Double.valueOf(value.asDouble())));
            }
            if (measures.isSetValue()) {
                measures.setUom("m");
                object.setStoreyHeightsAboveGround(measures);
            }
        }
        if ((storeyHeightsBelowGround = attributes.consume("storeyHeightsBelowGround")).isArray()) {
            MeasureOrNilReasonList measures = new MeasureOrNilReasonList();
            for (JsonNode value : storeyHeightsBelowGround) {
                if (!value.isNumber()) continue;
                measures.getValue().add(new DoubleOrNilReason(Double.valueOf(value.asDouble())));
            }
            if (measures.isSetValue()) {
                measures.setUom("m");
                object.setStoreyHeightsBelowGround(measures);
            }
        }
        if ((address = attributes.consume("address")).isArray()) {
            for (JsonNode element : address) {
                object.getAddresses().add(new AddressProperty((Address)helper.getObjectUsingBuilder(element, AddressAdapter.class)));
            }
        } else if (address.isObject()) {
            object.getAddresses().add(new AddressProperty((Address)helper.getObjectUsingBuilder(address, AddressAdapter.class)));
        }
        Iterator children = node.path("children").elements();
        block15: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "BuildingInstallation": {
                    object.getBuildingInstallations().add(new BuildingInstallationProperty(helper.getCityObject(child, BuildingInstallation.class)));
                    break;
                }
                case "BuildingConstructiveElement": {
                    object.getBuildingConstructiveElements().add(new BuildingConstructiveElementProperty(helper.getCityObject(child, BuildingConstructiveElement.class)));
                    break;
                }
                case "BuildingRoom": {
                    object.getBuildingRooms().add(new BuildingRoomProperty(helper.getCityObject(child, BuildingRoom.class)));
                    break;
                }
                case "BuildingFurniture": {
                    object.getBuildingFurniture().add(new BuildingFurnitureProperty(helper.getCityObject(child, BuildingFurniture.class)));
                    break;
                }
                default: {
                    continue block15;
                }
            }
            children.remove();
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        CityJSONVersion version = helper.getVersion();
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.getRoofType() != null) {
            attributes.put("roofType", object.getRoofType().getValue());
        }
        if (object.getStoreysAboveGround() != null) {
            attributes.put("storeysAboveGround", object.getStoreysAboveGround());
        }
        if (object.getStoreysBelowGround() != null) {
            attributes.put("storeysBelowGround", object.getStoreysBelowGround());
        }
        if (object.getStoreyHeightsAboveGround() != null && object.getStoreyHeightsAboveGround().isSetValue()) {
            ArrayNode storeyHeightsAboveGround = attributes.putArray("storeyHeightsAboveGround");
            for (DoubleOrNilReason value : object.getStoreyHeightsAboveGround().getValue()) {
                storeyHeightsAboveGround.add((Double)value.getValue());
            }
        }
        if (object.getStoreyHeightsBelowGround() != null && object.getStoreyHeightsBelowGround().isSetValue()) {
            ArrayNode storeyHeightsBelowGround = attributes.putArray("storeyHeightsBelowGround");
            for (DoubleOrNilReason value : object.getStoreyHeightsBelowGround().getValue()) {
                storeyHeightsBelowGround.add((Double)value.getValue());
            }
        }
        if (object.isSetAddresses()) {
            ArrayNode addresses = helper.createArray();
            for (AddressProperty property : object.getAddresses()) {
                ObjectNode address;
                if (!property.isSetObject() || (address = helper.getObjectUsingSerializer((Address)property.getObject(), AddressAdapter.class)).isEmpty()) continue;
                addresses.add((JsonNode)address);
                if (version != CityJSONVersion.v1_0) continue;
                break;
            }
            if (!addresses.isEmpty()) {
                node.set("address", (JsonNode)(version == CityJSONVersion.v1_0 ? addresses.get(0) : addresses));
            }
        }
        if (object.isSetBuildingInstallations()) {
            for (BuildingInstallationProperty property : object.getBuildingInstallations()) {
                if (!property.isSetInlineObject() || version == CityJSONVersion.v1_0 && ((BuildingInstallation)property.getObject()).getRelationToConstruction() != RelationToConstruction.OUTSIDE) continue;
                helper.writeChildObject((BuildingInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (version != CityJSONVersion.v1_0) {
            if (object.isSetBuildingConstructiveElements()) {
                for (BuildingInstallationProperty property : object.getBuildingConstructiveElements()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((BuildingConstructiveElement)property.getObject(), (AbstractFeature)object, node);
                }
            }
            if (object.isSetBuildingRooms()) {
                for (BuildingInstallationProperty property : object.getBuildingRooms()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((BuildingRoom)property.getObject(), (AbstractFeature)object, node);
                }
            }
            if (object.isSetBuildingFurniture()) {
                for (BuildingInstallationProperty property : object.getBuildingFurniture()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((BuildingFurniture)property.getObject(), (AbstractFeature)object, node);
                }
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes.get((Object)version);
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(T object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfAbstractBuilding properties = object.getDeprecatedProperties();
            return Map.of(1, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractBuilding)properties).getLod1MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractBuilding)properties).setLod1MultiSurface(arg_0)), 4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractBuilding)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractBuilding)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

