/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.appearance;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.util.texture.TextureFileHandler;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.appearance.ColorPlusOpacity;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.TextureType;
import org.citygml4j.core.model.appearance.WrapMode;
import org.xmlobjects.gml.model.basictypes.Code;

public class ParameterizedTextureAdapter
implements JsonObjectBuilder<ParameterizedTexture>,
JsonObjectSerializer<ParameterizedTexture> {
    @Override
    public ParameterizedTexture createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new ParameterizedTexture();
    }

    @Override
    public void buildObject(ParameterizedTexture object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode borderColor;
        JsonNode textureType;
        JsonNode wrapMode;
        String mimeType;
        JsonNode type;
        JsonNode image = node.path("image");
        if (image.isTextual()) {
            TextureFileHandler textureFileHandler = (TextureFileHandler)helper.getProperties().get(TextureFileHandler.class.getName(), TextureFileHandler.class);
            object.setImageURI(textureFileHandler != null ? textureFileHandler.getImageURI(image.asText()) : image.asText());
        }
        if ((type = node.path("type")).isTextual() && (mimeType = this.getMimeType(type.asText())) != null) {
            object.setMimeType(new Code(mimeType));
        }
        if ((wrapMode = node.path("wrapMode")).isTextual()) {
            object.setWrapMode(WrapMode.fromValue((String)wrapMode.asText()));
        }
        if ((textureType = node.path("textureType")).isTextual()) {
            object.setTextureType(TextureType.fromValue((String)textureType.asText()));
        }
        if ((borderColor = node.path("borderColor")).isArray() && borderColor.size() > 2) {
            ColorPlusOpacity value = new ColorPlusOpacity(borderColor.get(0).asDouble(), borderColor.get(1).asDouble(), borderColor.get(2).asDouble());
            JsonNode opacity = borderColor.path(3);
            if (opacity.isNumber()) {
                value.setOpacity(opacity.asDouble());
            }
            object.setBorderColor(value);
        }
    }

    @Override
    public void writeObject(ParameterizedTexture object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        String type = null;
        if (object.getMimeType() != null) {
            type = this.getType(object.getMimeType());
        }
        String image = null;
        if (object.getImageURI() != null) {
            TextureFileHandler textureFileHandler = (TextureFileHandler)helper.getProperties().get(TextureFileHandler.class.getName(), TextureFileHandler.class);
            image = textureFileHandler != null ? textureFileHandler.getImageURI(object.getImageURI()) : object.getImageURI();
            if (type == null) {
                type = this.getType(image);
            }
        }
        node.put("type", type);
        node.put("image", image);
        if (object.getWrapMode() != null) {
            node.put("wrapMode", object.getWrapMode().toValue());
        }
        if (object.getTextureType() != null) {
            node.put("textureType", object.getTextureType().toValue());
        }
        if (object.getBorderColor() != null) {
            ArrayNode borderColor = node.putArray("borderColor");
            object.getBorderColor().toList().forEach(arg_0 -> ((ArrayNode)borderColor).add(arg_0));
        }
    }

    private String getMimeType(String type) {
        return switch (type.toLowerCase(Locale.ROOT)) {
            case "png" -> "image/png";
            case "jpg" -> "image/jpeg";
            default -> null;
        };
    }

    private String getType(Code mimeType) {
        if (mimeType.getValue() != null) {
            return switch (mimeType.getValue().toLowerCase(Locale.ROOT)) {
                case "image/png" -> "PNG";
                case "image/jpeg" -> "JPG";
                default -> "unknown";
            };
        }
        return "unknown";
    }

    private String getType(String image) {
        int index = image.lastIndexOf(46);
        if (index >= 0 && index < image.length() - 1) {
            String extension;
            return switch (extension = image.substring(index + 1).toUpperCase(Locale.ROOT)) {
                case "JPG", "JPEG", "JPE", "JFIF", "JIF", "JFI", "PJPEG", "PJP" -> "JPG";
                default -> extension;
            };
        }
        return "unknown";
    }
}

