/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.atteo.classindex.ClassIndex;
import org.citygml4j.cityjson.CityJSONContextException;
import org.citygml4j.cityjson.ExtensionLoader;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.extension.Extension;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.reader.CityJSONInputFactory;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONOutputFactory;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.core.ade.ADEException;
import org.citygml4j.core.ade.ADERegistry;

public class CityJSONContext {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, Map<CityJSONVersion, BuilderInfo>> builders = new ConcurrentHashMap<String, Map<CityJSONVersion, BuilderInfo>>();
    private final Map<String, Map<CityJSONVersion, SerializerInfo>> serializers = new ConcurrentHashMap<String, Map<CityJSONVersion, SerializerInfo>>();

    private CityJSONContext(ClassLoader classLoader) throws CityJSONContextException {
        this.loadBuilders(classLoader, true);
        this.loadSerializers(classLoader, true);
        try {
            ADERegistry registry = ADERegistry.getInstance();
            for (Extension extension : registry.getADEs(Extension.class)) {
                this.loadExtension(extension);
            }
            this.removeUnregisteredExtensionObjects();
            ((ExtensionLoader)registry.getADELoader(ExtensionLoader.class)).addListener(this);
        }
        catch (ADEException e) {
            throw new CityJSONContextException("Failed to load CityJSON extensions.", e);
        }
    }

    public static CityJSONContext newInstance() throws CityJSONContextException {
        return CityJSONContext.newInstance(Thread.currentThread().getContextClassLoader());
    }

    public static CityJSONContext newInstance(ClassLoader classLoader) throws CityJSONContextException {
        return new CityJSONContext(classLoader);
    }

    public CityJSONInputFactory createCityJSONInputFactory() {
        return new CityJSONInputFactory(this.objectMapper, this);
    }

    public CityJSONOutputFactory createCityJSONOutputFactory(CityJSONVersion version) {
        return new CityJSONOutputFactory(version, this.objectMapper, this);
    }

    public CityJSONOutputFactory createCityJSONOutputFactory() {
        return this.createCityJSONOutputFactory(CityJSONVersion.v2_0);
    }

    public CityJSONContext registerBuilder(JsonObjectBuilder<?> builder, String name, CityJSONVersion version) throws CityJSONContextException {
        this.registerBuilder(builder, name, null, version, false);
        return this;
    }

    public JsonObjectBuilder<?> getBuilder(String name, CityJSONVersion version) {
        BuilderInfo info = (BuilderInfo)this.builders.getOrDefault(name, Collections.emptyMap()).get((Object)version);
        return info != null ? info.builder : null;
    }

    public <T> JsonObjectBuilder<T> getBuilder(String name, CityJSONVersion version, Class<T> objectType) {
        Objects.requireNonNull(objectType, "Object type must not be null.");
        BuilderInfo info = (BuilderInfo)this.builders.getOrDefault(name, Collections.emptyMap()).get((Object)version);
        return info != null && objectType.isAssignableFrom(info.objectType) ? info.builder : null;
    }

    public Class<?> getObjectType(JsonObjectBuilder<?> builder) {
        for (Map<CityJSONVersion, BuilderInfo> infos : this.builders.values()) {
            for (BuilderInfo info : infos.values()) {
                if (info.builder != builder) continue;
                return info.objectType;
            }
        }
        return Object.class;
    }

    public <T> CityJSONContext registerSerializer(JsonObjectSerializer<T> serializer, Class<T> objectType, CityJSONVersion version) throws CityJSONContextException {
        this.registerSerializer(serializer, objectType, null, version, false);
        return this;
    }

    public <T> JsonObjectSerializer<T> getSerializer(Class<T> objectType, CityJSONVersion version) {
        SerializerInfo info = (SerializerInfo)this.serializers.getOrDefault(objectType.getName(), Collections.emptyMap()).get((Object)version);
        return info != null ? info.serializer : null;
    }

    private void loadBuilders(ClassLoader classLoader, boolean failOnDuplicates) throws CityJSONContextException {
        for (Class type : ClassIndex.getSubclasses(JsonObjectBuilder.class, (ClassLoader)classLoader).stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(c -> c.isAnnotationPresent(CityJSONElement.class) || c.isAnnotationPresent(CityJSONElements.class)).toList()) {
            JsonObjectBuilder builder;
            boolean isSetElement = type.isAnnotationPresent(CityJSONElement.class);
            boolean isSetElements = type.isAnnotationPresent(CityJSONElements.class);
            if (isSetElement && isSetElements) {
                throw new CityJSONContextException("The builder " + type.getName() + " uses both @CityJSONElement and @CityJSONElements.");
            }
            try {
                builder = (JsonObjectBuilder)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CityJSONContextException("The builder " + type.getName() + " lacks a default constructor.", e);
            }
            if (isSetElement) {
                CityJSONElement element = type.getAnnotation(CityJSONElement.class);
                this.registerBuilder(builder, element.name(), element.schema(), element.version(), failOnDuplicates);
                continue;
            }
            if (!isSetElements) continue;
            CityJSONElements elements = type.getAnnotation(CityJSONElements.class);
            for (CityJSONElement element : elements.value()) {
                this.registerBuilder(builder, element.name(), element.schema(), element.version(), failOnDuplicates);
            }
        }
    }

    private void loadSerializers(ClassLoader classLoader, boolean failOnDuplicates) throws CityJSONContextException {
        for (Class type : ClassIndex.getSubclasses(JsonObjectSerializer.class, (ClassLoader)classLoader).stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(c -> c.isAnnotationPresent(CityJSONElement.class) || c.isAnnotationPresent(CityJSONElements.class)).toList()) {
            JsonObjectSerializer serializer;
            boolean isSetElement = type.isAnnotationPresent(CityJSONElement.class);
            boolean isSetElements = type.isAnnotationPresent(CityJSONElements.class);
            if (isSetElement && isSetElements) {
                throw new CityJSONContextException("The serializer " + type.getName() + " uses both @CityJSONElement and @CityJSONElements.");
            }
            try {
                serializer = (JsonObjectSerializer)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CityJSONContextException("The serializer " + type.getName() + " lacks a default constructor.", e);
            }
            Class<?> objectType = this.findObjectType(serializer);
            if (isSetElement) {
                CityJSONElement element = type.getAnnotation(CityJSONElement.class);
                this.registerSerializer(serializer, objectType, element.schema(), element.version(), failOnDuplicates);
                continue;
            }
            if (!isSetElements) continue;
            CityJSONElements elements = type.getAnnotation(CityJSONElements.class);
            for (CityJSONElement element : elements.value()) {
                this.registerSerializer(serializer, objectType, element.schema(), element.version(), failOnDuplicates);
            }
        }
    }

    public void unloadBuilders(CityJSONVersion version) {
        if (version != null) {
            this.builders.values().forEach(v -> v.remove((Object)version));
        }
    }

    public void unloadSerializers(CityJSONVersion version) {
        if (version != null) {
            this.serializers.values().forEach(v -> v.remove((Object)version));
        }
    }

    private void registerBuilder(JsonObjectBuilder<?> builder, String name, String schema, CityJSONVersion version, boolean failOnDuplicates) throws CityJSONContextException {
        BuilderInfo info = new BuilderInfo(builder, schema, this.findObjectType(builder));
        BuilderInfo current = this.builders.computeIfAbsent(name, v -> new HashMap()).put(version, info);
        if (current != null && current.builder != builder && failOnDuplicates) {
            throw new CityJSONContextException("Two builders are registered for the CityJSON " + version + " element " + name + ": " + builder.getClass().getName() + " and " + current.builder.getClass().getName() + ".");
        }
    }

    private void registerSerializer(JsonObjectSerializer<?> serializer, Class<?> objectType, String schema, CityJSONVersion version, boolean failOnDuplicates) throws CityJSONContextException {
        SerializerInfo info = new SerializerInfo(serializer, schema);
        SerializerInfo current = this.serializers.computeIfAbsent(objectType.getName(), v -> new HashMap()).put(version, info);
        if (current != null && current.serializer != serializer && failOnDuplicates) {
            throw new CityJSONContextException("Two serializers are registered for the object type " + objectType.getName() + ": " + serializer.getClass().getName() + " and " + current.getClass().getName() + ".");
        }
    }

    private Class<?> findObjectType(JsonObjectBuilder<?> builder) throws CityJSONContextException {
        try {
            return builder.getClass().getMethod("createObject", JsonNode.class, Object.class).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new CityJSONContextException("The builder " + builder.getClass().getName() + " lacks the createObject method.", e);
        }
    }

    private Class<?> findObjectType(JsonObjectSerializer<?> serializer) throws CityJSONContextException {
        Class<?> clazz = serializer.getClass();
        Class<?> objectType = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || !Modifier.isPublic(method.getModifiers())) continue;
            Class<?> candidateType = null;
            switch (method.getName()) {
                case "createType": {
                    Class<?>[] parameters = method.getParameterTypes();
                    if (parameters.length != 2 || parameters[1] != CityJSONVersion.class) break;
                    candidateType = parameters[0];
                    break;
                }
                case "writeObject": {
                    Class<?>[] parameters = method.getParameterTypes();
                    if (parameters.length != 3 || parameters[1] != ObjectNode.class || parameters[2] != CityJSONSerializerHelper.class) break;
                    return parameters[0];
                }
            }
            if (candidateType == null) continue;
            if (objectType != null && candidateType != objectType) {
                throw new CityJSONContextException("The serializer " + serializer.getClass().getName() + " uses different object types: " + objectType.getName() + " and " + candidateType.getName() + ".");
            }
            objectType = candidateType;
        }
        if (objectType != null) {
            return objectType;
        }
        throw new CityJSONContextException("The serializer " + serializer.getClass().getName() + " must implement at least one of the methods createType and writeObject.");
    }

    void loadExtension(Extension extension) throws ADEException {
        try {
            this.loadExtensionObjects(extension.getClass().getClassLoader());
        }
        catch (CityJSONContextException e) {
            throw new ADEException("Failed to load extension.", (Throwable)e);
        }
    }

    void unloadExtension(Extension extension) {
        this.unloadExtensionObjects(extension.getName());
    }

    private void loadExtensionObjects(ClassLoader classLoader) throws CityJSONContextException {
        this.loadBuilders(classLoader, false);
        this.loadSerializers(classLoader, false);
        this.removeUnregisteredExtensionObjects();
    }

    private void unloadExtensionObjects(String name) {
        this.builders.values().forEach(v -> v.values().removeIf(info -> info.schema.equals(name)));
        this.serializers.values().forEach(v -> v.values().removeIf(info -> info.schema.equals(name)));
    }

    private void removeUnregisteredExtensionObjects() {
        ExtensionLoader loader = (ExtensionLoader)ADERegistry.getInstance().getADELoader(ExtensionLoader.class);
        Set<String> extensionNames = loader.getExtensionNames();
        Set schemas = this.serializers.values().stream().flatMap(map -> map.values().stream()).map(info -> info.schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if ("CityJSON-Core".equals(schema) || extensionNames.contains(schema)) continue;
            this.unloadExtensionObjects(schema);
        }
    }

    private static class BuilderInfo {
        final JsonObjectBuilder<?> builder;
        final String schema;
        final Class<?> objectType;

        BuilderInfo(JsonObjectBuilder<?> builder, String schema, Class<?> objectType) {
            this.builder = builder;
            this.schema = schema;
            this.objectType = objectType;
        }
    }

    private static class SerializerInfo {
        final JsonObjectSerializer<?> serializer;
        final String schema;

        SerializerInfo(JsonObjectSerializer<?> serializer, String schema) {
            this.serializer = serializer;
            this.schema = schema;
        }
    }
}

