/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometrySerializer;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.util.texture.DefaultTextureFileHandler;
import org.citygml4j.cityjson.util.texture.TextureFileHandler;
import org.citygml4j.cityjson.writer.AbstractCityJSONWriter;
import org.citygml4j.cityjson.writer.CityJSONFeatureWriter;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.cityjson.writer.CityJSONWriter;
import org.citygml4j.cityjson.writer.OutputEncoding;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.util.Properties;

public class CityJSONOutputFactory {
    private final ObjectMapper objectMapper;
    private final CityJSONContext context;
    private final Properties properties = new Properties();
    private CityJSONVersion version;
    private IdCreator idCreator;
    private int vertexPrecision = 3;
    private int templatePrecision = 3;
    private int textureVertexPrecision = 7;
    private boolean applyTransformation;
    private boolean computeCityModelExtent = true;
    private boolean transformTemplateGeometries;
    private boolean writeGenericAttributeTypes;
    private String fallbackTheme = "unnamed";

    public CityJSONOutputFactory(CityJSONVersion version, ObjectMapper objectMapper, CityJSONContext context) {
        this.version = version;
        this.objectMapper = objectMapper;
        this.context = context;
        this.withTextureFileHandler(new DefaultTextureFileHandler());
        this.useMaterialDefaults(true);
    }

    public CityJSONVersion getVersion() {
        return this.version;
    }

    public CityJSONOutputFactory withCityJSONVersion(CityJSONVersion version) {
        this.version = Objects.requireNonNull(version, "The CityJSON version must not be null.");
        return this;
    }

    public IdCreator getIdCreator() {
        return this.idCreator;
    }

    public CityJSONOutputFactory withIdCreator(IdCreator idCreator) {
        this.idCreator = Objects.requireNonNull(idCreator, "The ID creator must not be null.");
        return this;
    }

    public int getVertexPrecision() {
        return this.vertexPrecision;
    }

    public CityJSONOutputFactory withVertexPrecision(int vertexPrecision) {
        if (vertexPrecision >= 0) {
            this.vertexPrecision = vertexPrecision;
        }
        return this;
    }

    public int getTemplatePrecision() {
        return this.templatePrecision;
    }

    public CityJSONOutputFactory withTemplatePrecision(int templatePrecision) {
        if (templatePrecision >= 0) {
            this.templatePrecision = templatePrecision;
        }
        return this;
    }

    public int getTextureVertexPrecision() {
        return this.textureVertexPrecision;
    }

    public CityJSONOutputFactory withTextureVertexPrecision(int textureVertexPrecision) {
        if (textureVertexPrecision >= 0) {
            this.textureVertexPrecision = textureVertexPrecision;
        }
        return this;
    }

    public boolean isApplyTransformation() {
        return this.applyTransformation;
    }

    public CityJSONOutputFactory applyTransformation(boolean applyTransformation) {
        this.applyTransformation = applyTransformation;
        return this;
    }

    public boolean isComputeCityModelExtent() {
        return this.computeCityModelExtent;
    }

    public CityJSONOutputFactory computeCityModelExtent(boolean computeCityModelExtent) {
        this.computeCityModelExtent = computeCityModelExtent;
        return this;
    }

    public boolean isTransformTemplateGeometries() {
        return this.transformTemplateGeometries;
    }

    public CityJSONOutputFactory transformTemplateGeometries(boolean convertTemplateGeometries) {
        this.transformTemplateGeometries = convertTemplateGeometries;
        return this;
    }

    public boolean isWriteGenericAttributeTypes() {
        return this.writeGenericAttributeTypes;
    }

    public CityJSONOutputFactory writeGenericAttributeTypes(boolean writeGenericAttributeTypes) {
        this.writeGenericAttributeTypes = writeGenericAttributeTypes;
        return this;
    }

    public TextureFileHandler getTextureFileHandler() {
        return (TextureFileHandler)this.properties.get(TextureFileHandler.class.getName(), TextureFileHandler.class);
    }

    public CityJSONOutputFactory withTextureFileHandler(TextureFileHandler textureFileHandler) {
        Objects.requireNonNull(textureFileHandler, "The texture file handler must not be null.");
        this.withProperty(TextureFileHandler.class.getName(), textureFileHandler);
        return this;
    }

    public String getFallbackTheme() {
        return this.fallbackTheme;
    }

    public CityJSONOutputFactory withFallbackTheme(String fallbackTheme) {
        this.fallbackTheme = fallbackTheme != null ? fallbackTheme : "unnamed";
        return this;
    }

    public boolean isUseMaterialDefaults() {
        return this.properties.getAndCompare("org.citygml4j.cityjson.useMaterialDefaults", (Object)true);
    }

    public CityJSONOutputFactory useMaterialDefaults(boolean useMaterialDefaults) {
        this.withProperty("org.citygml4j.cityjson.useMaterialDefaults", useMaterialDefaults);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public CityJSONOutputFactory withProperty(String name, Object value) {
        this.properties.set(name, value);
        return this;
    }

    public CityJSONWriter createCityJSONWriter(File file) throws CityJSONWriteException {
        return this.createCityJSONWriter(file, OutputEncoding.UTF8);
    }

    public CityJSONWriter createCityJSONWriter(File file, OutputEncoding encoding) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONWriter(this.objectMapper.createGenerator(file, encoding.toJsonEncoding())));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(Path path) throws CityJSONWriteException {
        return this.createCityJSONWriter(path, OutputEncoding.UTF8);
    }

    public CityJSONWriter createCityJSONWriter(Path path, OutputEncoding encoding) throws CityJSONWriteException {
        try {
            return this.createCityJSONWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), encoding.toJsonEncoding().getJavaName()));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(OutputStream stream) throws CityJSONWriteException {
        return this.createCityJSONWriter(stream, OutputEncoding.UTF8);
    }

    public CityJSONWriter createCityJSONWriter(OutputStream stream, OutputEncoding encoding) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONWriter(this.objectMapper.createGenerator(stream, encoding.toJsonEncoding())));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(Writer writer) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONWriter(this.objectMapper.createGenerator(writer)));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONWriter createCityJSONWriter(DataOutput dataOutput) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONWriter(this.objectMapper.createGenerator(dataOutput)));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(File file) throws CityJSONWriteException {
        return this.createCityJSONFeatureWriter(file, OutputEncoding.UTF8);
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(File file, OutputEncoding encoding) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONFeatureWriter(this.objectMapper.createGenerator(file, encoding.toJsonEncoding())));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(Path path) throws CityJSONWriteException {
        return this.createCityJSONFeatureWriter(path, OutputEncoding.UTF8);
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(Path path, OutputEncoding encoding) throws CityJSONWriteException {
        try {
            return this.createCityJSONFeatureWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), encoding.toJsonEncoding().getJavaName()));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(OutputStream stream) throws CityJSONWriteException {
        return this.createCityJSONFeatureWriter(stream, OutputEncoding.UTF8);
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(OutputStream stream, OutputEncoding encoding) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONFeatureWriter(this.objectMapper.createGenerator(stream, encoding.toJsonEncoding())));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(Writer writer) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONFeatureWriter(this.objectMapper.createGenerator(writer)));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public CityJSONFeatureWriter createCityJSONFeatureWriter(DataOutput dataOutput) throws CityJSONWriteException {
        try {
            return this.initialize(new CityJSONFeatureWriter(this.objectMapper.createGenerator(dataOutput)));
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    private <T extends AbstractCityJSONWriter<?>> T initialize(T writer) {
        boolean writeCityJSONFeature = writer instanceof CityJSONFeatureWriter;
        CityJSONSerializerHelper helper = new CityJSONSerializerHelper(writer, writeCityJSONFeature ? CityJSONVersion.max(this.version, CityJSONVersion.v1_1) : this.version, this.objectMapper, this.context);
        helper.setProperties(this.properties);
        helper.setApplyTransformation(writeCityJSONFeature || this.applyTransformation);
        helper.setComputeCityModelExtent(!writeCityJSONFeature && this.computeCityModelExtent);
        helper.setWriteGenericAttributeTypes(!writeCityJSONFeature && this.writeGenericAttributeTypes);
        GeometrySerializer geometrySerializer = helper.getGeometrySerializer();
        geometrySerializer.setTransformTemplateGeometries(writeCityJSONFeature || this.transformTemplateGeometries);
        if (this.vertexPrecision != 3) {
            geometrySerializer.getVerticesBuilder().setPrecision(this.vertexPrecision);
        }
        if (this.templatePrecision != 3) {
            geometrySerializer.getTemplatesVerticesBuilder().setPrecision(this.templatePrecision);
        }
        AppearanceSerializer appearanceSerializer = helper.getAppearanceSerializer();
        appearanceSerializer.setFallbackTheme(this.fallbackTheme);
        if (this.textureVertexPrecision != 7) {
            appearanceSerializer.getTextureVerticesBuilder().setPrecision(this.textureVertexPrecision);
        }
        if (this.idCreator != null) {
            helper.setIdCreator(this.idCreator);
        }
        writer.helper = helper;
        return writer;
    }
}

