/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.util.composite;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;

public abstract class CompositeJsonObjectSerializer<T>
implements JsonObjectSerializer<T> {
    private final Class<? extends JsonObjectSerializer<T>> serializer;

    public <S extends JsonObjectSerializer<? super T>> CompositeJsonObjectSerializer(Class<S> adapter) {
        this.serializer = Objects.requireNonNull(adapter, "Object serializer must not be null.");
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        helper.getOrCreateSerializer(this.serializer).writeObject(object, node, helper);
    }
}

