/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceBuilder;
import org.citygml4j.cityjson.adapter.core.AbstractFeatureAdapter;
import org.citygml4j.cityjson.adapter.core.AbstractSemanticObjectAdapter;
import org.citygml4j.cityjson.adapter.core.AbstractSpaceAdapter;
import org.citygml4j.cityjson.adapter.extension.ExtensionInfo;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.builder.TypeMapper;
import org.citygml4j.cityjson.model.CityJSONType;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.generics.GenericAttributeType;
import org.citygml4j.cityjson.model.generics.GenericAttributeTypes;
import org.citygml4j.cityjson.model.metadata.Metadata;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.reader.CityJSONReader;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.cityjson.util.GenericAttributeTypeParser;
import org.citygml4j.cityjson.util.lod.LodMapper;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.core.model.ade.ADEObject;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.core.ADEOfCityModel;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractGenericAttribute;
import org.citygml4j.core.model.core.AbstractGenericAttributeProperty;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.util.id.DefaultIdCreator;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.util.Properties;

public class CityJSONBuilderHelper {
    private final CityJSONReader reader;
    private final CityJSONType type;
    private final CityJSONVersion version;
    private final ObjectMapper objectMapper;
    private final CityJSONContext context;
    private final Map<Class<?>, JsonObjectBuilder<?>> builderCache = new IdentityHashMap();
    private ObjectNode cityObjects;
    private GeometryBuilder geometryBuilder;
    private AppearanceBuilder appearanceBuilder;
    private WeakReference<?> parent = new WeakReference<Object>(null);
    private CityGMLVersion targetCityGMLVersion = CityGMLVersion.v3_0;
    private boolean mapUnsupportedTypesToGenerics = true;
    private IdCreator idCreator = DefaultIdCreator.getInstance();
    private Metadata metadata;
    private Map<String, ExtensionInfo> extensions;
    private Map<String, ADEOfCityModel> extraRootProperties;
    private GenericAttributeTypes genericAttributeTypes = new GenericAttributeTypes();
    private Properties properties;

    private CityJSONBuilderHelper(CityJSONReader reader, CityJSONType type, CityJSONVersion version, ObjectMapper objectMapper, CityJSONContext context) {
        this.reader = reader;
        this.type = type;
        this.version = version;
        this.objectMapper = objectMapper;
        this.context = context;
    }

    static CityJSONBuilderHelper buildFor(CityJSONReader reader, ObjectNode content, ObjectNode globalScope, ObjectMapper objectMapper, CityJSONContext context) throws CityJSONBuildException {
        CityJSONVersion version;
        CityJSONType type = CityJSONType.fromValue(content.path("type").asText());
        if (type == null) {
            throw new CityJSONBuildException("Expected \"type\" property with one of the values: " + Arrays.stream(CityJSONType.values()).map(CityJSONType::toTypeName).collect(Collectors.joining(", ")));
        }
        if (content.path("version").isValueNode()) {
            globalScope.set("version", content.path("version"));
        }
        if (content.path("transform").isObject()) {
            globalScope.set("transform", content.path("transform"));
        }
        if (content.path("geometry-templates").isObject()) {
            globalScope.set("geometry-templates", content.path("geometry-templates"));
        }
        if ((version = CityJSONVersion.fromValue(globalScope.path("version").asText())) == null) {
            throw new CityJSONBuildException((String)(globalScope.get("version") == null ? "No CityJSON version found in document." : "Unsupported CityJSON version " + globalScope.get("version") + "."));
        }
        CityJSONBuilderHelper helper = new CityJSONBuilderHelper(reader, type, version, objectMapper, context);
        helper.cityObjects = helper.getOrPutObject("CityObjects", content);
        ObjectNode appearance = helper.getOrPutObject("appearance", content);
        ArrayNode vertices = helper.getOrPutArray("vertices", content);
        ObjectNode templates = helper.getOrPutObject("geometry-templates", globalScope);
        ObjectNode transform = helper.getOrPutObject("transform", globalScope);
        helper.appearanceBuilder = new AppearanceBuilder(appearance, helper);
        helper.geometryBuilder = new GeometryBuilder(vertices, templates, helper.appearanceBuilder, helper);
        helper.geometryBuilder.getVerticesBuilder().applyTransformation(transform);
        return helper;
    }

    public CityJSONType getType() {
        return this.type;
    }

    public CityJSONVersion getVersion() {
        return this.version;
    }

    public CityJSONContext getContext() {
        return this.context;
    }

    ObjectNode getCityObjects() {
        return this.cityObjects;
    }

    boolean hasGlobalAppearances() {
        return this.geometryBuilder.hasGlobalAppearances();
    }

    List<Appearance> getGlobalAppearances() {
        return this.geometryBuilder.getGlobalAppearances();
    }

    public CityGMLVersion getTargetCityGMLVersion() {
        return this.targetCityGMLVersion;
    }

    void setTargetCityGMLVersion(CityGMLVersion targetCityGMLVersion) {
        this.targetCityGMLVersion = Objects.requireNonNull(targetCityGMLVersion, "The target CityGML version must not be null.");
    }

    public boolean isMapUnsupportedTypesToGenerics() {
        return this.mapUnsupportedTypesToGenerics;
    }

    void setMapUnsupportedTypesToGenerics(boolean mapUnsupportedTypesToGenerics) {
        this.mapUnsupportedTypesToGenerics = mapUnsupportedTypesToGenerics;
    }

    public boolean isTransformTemplateGeometries() {
        return this.geometryBuilder.isTransformTemplateGeometries();
    }

    void setTransformTemplateGeometries(boolean transformTemplateGeometries) {
        this.geometryBuilder.setTransformTemplateGeometries(transformTemplateGeometries);
    }

    public boolean isAssignAppearancesToImplicitGeometries() {
        return this.geometryBuilder.isAssignAppearancesToImplicitGeometries();
    }

    void setAssignAppearancesToImplicitGeometries(boolean assignAppearancesToImplicitGeometries) {
        this.geometryBuilder.setAssignAppearancesToImplicitGeometries(assignAppearancesToImplicitGeometries);
    }

    public IdCreator getIdCreator() {
        return this.idCreator;
    }

    void setIdCreator(IdCreator idCreator) {
        this.idCreator = Objects.requireNonNull(idCreator, "The ID creator must not be null.");
    }

    public LodMapper getLodMapper() {
        return this.geometryBuilder.getLodMapper();
    }

    void setLodMapper(LodMapper lodMapper) {
        this.geometryBuilder.setLodMapper(lodMapper);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public Collection<ExtensionInfo> getExtensions() {
        return this.hasExtensions() ? this.extensions.values() : Collections.emptyList();
    }

    public ExtensionInfo getExtension(String name) {
        return this.hasExtensions() ? this.extensions.get(name) : null;
    }

    void setExtensions(Map<String, ExtensionInfo> extensions) {
        this.extensions = extensions;
    }

    public boolean hasExtraRootProperties() {
        return this.extraRootProperties != null && !this.extraRootProperties.isEmpty();
    }

    public <T extends ADEOfCityModel> T getExtraRootProperty(String propertyName, Class<T> type) {
        ADEOfCityModel property;
        if (this.hasExtraRootProperties() && type.isInstance(property = this.extraRootProperties.get(propertyName))) {
            return (T)((ADEOfCityModel)type.cast(property));
        }
        return null;
    }

    void setExtraRootProperties(Map<String, ADEOfCityModel> extraRootProperties) {
        this.extraRootProperties = extraRootProperties;
        GenericAttributeTypes genericAttributeTypes = this.getExtraRootProperty("+GenericAttributeTypes", GenericAttributeTypes.class);
        if (genericAttributeTypes != null) {
            this.genericAttributeTypes = genericAttributeTypes;
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getOrCreateId(AbstractGML object) {
        if (object.getId() == null) {
            object.setId(this.idCreator.createId());
        }
        return object.getId();
    }

    public ObjectNode createObject() {
        return this.objectMapper.createObjectNode();
    }

    public ObjectNode getOrPutObject(String propertyName, ObjectNode node) {
        JsonNode candidate = node.path(propertyName);
        return candidate.isObject() ? (ObjectNode)candidate : node.putObject(propertyName);
    }

    public ArrayNode createArray() {
        return this.objectMapper.createArrayNode();
    }

    public ArrayNode getOrPutArray(String propertyName, ObjectNode node) {
        JsonNode candidate = node.path(propertyName);
        return candidate.isArray() ? (ArrayNode)candidate : node.putArray(propertyName);
    }

    public JsonNode consumeProperty(String propertyName, JsonNode node) {
        JsonNode property = node.path(propertyName);
        if (node.isObject()) {
            ((ObjectNode)node).remove(propertyName);
        }
        return property;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractGenericAttribute<?> getGenericAttribute(String name, JsonNode node) throws CityJSONBuildException, CityJSONReadException {
        GenericAttributeType type = this.genericAttributeTypes.getType(name);
        if (type == null) {
            if (node.isNumber()) {
                type = node.isIntegralNumber() ? GenericAttributeType.INT_ATTRIBUTE : GenericAttributeType.DOUBLE_ATTRIBUTE;
            } else if (node.isTextual()) {
                type = GenericAttributeTypeParser.isLocalDate(node.asText()) ? GenericAttributeType.DATE_ATTRIBUTE : (GenericAttributeTypeParser.isUri(node.asText()) ? GenericAttributeType.URI_ATTRIBUTE : GenericAttributeType.STRING_ATTRIBUTE);
            } else if (node.isArray()) {
                type = GenericAttributeType.GENERIC_ATTRIBUTE_SET;
            } else if (node.isObject()) {
                JsonNode value = node.get("value");
                if (value != null) {
                    if (value.isNumber() && node.path("uom").isTextual()) {
                        type = GenericAttributeType.MEASURE_ATTRIBUTE;
                    } else {
                        if (!value.isTextual() || !node.path("codeSpace").isTextual()) return this.getGenericAttribute(name, value);
                        type = GenericAttributeType.CODE_ATTRIBUTE;
                    }
                } else {
                    type = GenericAttributeType.GENERIC_ATTRIBUTE_SET;
                }
            } else {
                type = GenericAttributeType.STRING_ATTRIBUTE;
            }
        }
        AbstractGenericAttribute attribute = this.getObject(type.toTypeName(), node, AbstractGenericAttribute.class);
        attribute.setName(name);
        return attribute;
    }

    public Map<Double, List<JsonNode>> groupGeometriesByLod(JsonNode geometries) {
        return this.geometryBuilder.groupGeometriesByLod(geometries);
    }

    public GeometryObject getGeometry(AbstractFeature object, JsonNode geometry, int lod) {
        return this.getGeometry(object, geometry, lod, null);
    }

    public GeometryObject getGeometry(AbstractFeature object, JsonNode geometry, int lod, BoundaryFilter filter) {
        return this.geometryBuilder.getGeometry(object, geometry, lod, filter);
    }

    public GeometryObject getGeometry(AbstractFeature object, JsonNode geometry) {
        return this.getGeometry(object, geometry, geometry.path("lod").asInt(-1));
    }

    public Map<Integer, List<GeometryObject>> getGeometries(AbstractFeature object, JsonNode geometries) {
        return this.getGeometries(object, geometries, null);
    }

    public Map<Integer, List<GeometryObject>> getGeometries(AbstractFeature object, JsonNode geometries, BoundaryFilter filter) {
        return this.geometryBuilder.getGeometries(object, geometries, filter);
    }

    public void addGeometries(AbstractSpace object, JsonNode geometries) {
        this.addGeometries(object, geometries, null);
    }

    public void addGeometries(AbstractSpace object, JsonNode geometries, BoundaryFilter filter) {
        this.geometryBuilder.addGeometries(object, geometries, filter);
    }

    public void buildStandardObjectClassifier(StandardObjectClassifier object, Attributes attributes) {
        JsonNode usage;
        JsonNode function;
        JsonNode classifier = attributes.consume("class");
        if (classifier.isTextual()) {
            object.setClassifier(new Code(classifier.asText()));
        }
        if ((function = attributes.consume("function")).isTextual()) {
            object.getFunctions().add(new Code(function.asText()));
        }
        if ((usage = attributes.consume("usage")).isTextual()) {
            object.getUsages().add(new Code(usage.asText()));
        }
    }

    public void buildAsTopLevelObject(String identifier) {
        this.reader.buildAsTopLevelObject(identifier);
    }

    public ObjectNode getCityObjectNode(String identifier) {
        JsonNode node = this.cityObjects.path(identifier);
        return node.isObject() ? (ObjectNode)node : null;
    }

    public String getCityObjectType(String identifier) {
        return this.cityObjects.path(identifier).path("type").asText();
    }

    public AbstractFeature getCityObject(String identifier) throws CityJSONBuildException, CityJSONReadException {
        return this.getCityObject(identifier, AbstractFeature.class);
    }

    public <T extends AbstractFeature> T getCityObject(String identifier, Class<T> type) throws CityJSONBuildException, CityJSONReadException {
        AbstractFeature cityObject = (AbstractFeature)this.getObject(this.cityObjects.get(identifier), type);
        if (cityObject != null) {
            cityObject.setId(identifier);
        }
        return (T)cityObject;
    }

    public <T> T getObject(JsonNode node, Class<T> type) throws CityJSONBuildException, CityJSONReadException {
        return node != null ? (T)this.getObject(node.path("type").asText(), node, type) : null;
    }

    public <T> T getObject(String name, JsonNode node, Class<T> type) throws CityJSONBuildException, CityJSONReadException {
        if (node != null) {
            JsonObjectBuilder<T> builder = this.context.getBuilder(name, this.version, type);
            if (builder == null && this.mapUnsupportedTypesToGenerics) {
                name = this.version == CityJSONVersion.v1_0 ? "GenericCityObject" : "+GenericCityObject";
                builder = this.context.getBuilder(name, this.version, type);
            }
            if (builder != null) {
                String mapping;
                if (builder instanceof TypeMapper && (mapping = ((TypeMapper)((Object)builder)).mapType(node, type)) != null && !name.equals(mapping)) {
                    return this.getObject(mapping, node, type);
                }
                return this.processObject(node, builder);
            }
        }
        return null;
    }

    public <T> T getObjectUsingBuilder(JsonNode node, Class<? extends JsonObjectBuilder<T>> type) throws CityJSONBuildException, CityJSONReadException {
        return this.getObjectUsingBuilder(node, this.getOrCreateBuilder(type));
    }

    public <T> T getObjectUsingBuilder(JsonNode node, JsonObjectBuilder<T> builder) throws CityJSONBuildException, CityJSONReadException {
        return node != null ? (T)this.processObject(node, builder) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T processObject(JsonNode node, JsonObjectBuilder<T> builder) throws CityJSONBuildException, CityJSONReadException {
        WeakReference<?> previous = this.parent;
        try {
            boolean isSemanticObject;
            T object = builder.createObject(node, previous.get());
            if (object == null) {
                throw new CityJSONBuildException("The builder " + builder.getClass().getName() + " created a null value.");
            }
            this.parent = new WeakReference<T>(object);
            boolean isObject = node.isObject() && node.path("type").isTextual();
            boolean isCityObject = isObject && builder instanceof AbstractFeatureAdapter;
            boolean bl = isSemanticObject = isObject && builder instanceof AbstractSemanticObjectAdapter;
            if (this.targetCityGMLVersion != CityGMLVersion.v3_0 && builder instanceof AbstractSpaceAdapter) {
                AbstractSpace space = (AbstractSpace)object;
                space.getDeprecatedProperties();
                this.geometryBuilder.setMultiSurfaceProviders(space, ((AbstractSpaceAdapter)builder).getMultiSurfaceProviders(space));
            }
            Attributes attributes = isCityObject || isSemanticObject ? this.createAttributes((ObjectNode)node) : new Attributes();
            builder.buildObject(object, attributes, node, previous.get(), this);
            if (!attributes.isEmpty()) {
                this.processAttributes(attributes, object, node);
            }
            if (isCityObject && !(object instanceof ADEObject)) {
                this.processChildren(node);
            }
            T t = object;
            return t;
        }
        finally {
            this.parent = previous;
        }
    }

    private void processAttributes(Attributes attributes, Object parent, JsonNode node) throws CityJSONBuildException, CityJSONReadException {
        boolean supportsGenericAttributes = parent instanceof AbstractCityObject;
        while (!attributes.isEmpty()) {
            Map.Entry<String, JsonNode> entry = attributes.consumeNext();
            String name = entry.getKey();
            JsonObjectBuilder<?> attributeBuilder = this.context.getBuilder(name, this.version);
            if (attributeBuilder != null) {
                this.getAttribute(attributes, node, parent, attributeBuilder);
                continue;
            }
            if (!supportsGenericAttributes) continue;
            AbstractGenericAttribute<?> attribute = this.getGenericAttribute(name, entry.getValue());
            ((AbstractCityObject)parent).getGenericAttributes().add(new AbstractGenericAttributeProperty(attribute));
        }
    }

    private <T> void getAttribute(Attributes attributes, JsonNode node, Object parent, JsonObjectBuilder<T> builder) throws CityJSONBuildException, CityJSONReadException {
        T object = builder.createObject(node, parent);
        if (object == null) {
            throw new CityJSONBuildException("The builder " + builder.getClass().getName() + " created a null value.");
        }
        builder.buildObject(object, attributes, node, parent, this);
    }

    private void processChildren(JsonNode node) throws CityJSONBuildException, CityJSONReadException {
        for (JsonNode child : node.path("children")) {
            String type = this.getCityObjectType(child.asText());
            JsonObjectBuilder<?> childBuilder = this.context.getBuilder(type, this.version);
            if (childBuilder == null) continue;
            this.processObject((JsonNode)this.getCityObjectNode(child.asText()), childBuilder);
        }
    }

    public <T> JsonObjectBuilder<T> getOrCreateBuilder(Class<? extends JsonObjectBuilder<T>> type) throws CityJSONBuildException {
        JsonObjectBuilder<?> cachedBuilder = this.builderCache.get(type);
        if (cachedBuilder != null && type.isAssignableFrom(cachedBuilder.getClass())) {
            return type.cast(cachedBuilder);
        }
        try {
            JsonObjectBuilder<T> builder = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.builderCache.put(type, builder);
            return builder;
        }
        catch (Exception e) {
            throw new CityJSONBuildException("The builder " + type.getName() + " lacks a default constructor.");
        }
    }

    void removeChildren(JsonNode parent, String parentId, Set<String> retain) {
        JsonNode children = parent.path("children");
        if (children.isArray()) {
            block0: for (JsonNode element : children) {
                String childId = element.asText();
                if (retain.contains(childId)) continue;
                JsonNode child = this.cityObjects.path(childId);
                JsonNode parents = child.path("parents");
                if (parents.size() > 1) {
                    Iterator iter = parents.elements();
                    while (iter.hasNext()) {
                        if (!parentId.equals(((JsonNode)iter.next()).asText())) continue;
                        iter.remove();
                        continue block0;
                    }
                    continue;
                }
                this.cityObjects.remove(childId);
                this.removeChildren(child, childId, retain);
            }
        }
    }

    private Attributes createAttributes(ObjectNode node) {
        Attributes attributes = new Attributes();
        Iterator iterator = node.fields();
        block12: while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String name = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            switch (name) {
                case "type": 
                case "geometry": 
                case "children": 
                case "parents": 
                case "parent": {
                    continue block12;
                }
                case "attributes": {
                    Iterator attrIterator = value.fields();
                    while (attrIterator.hasNext()) {
                        Map.Entry attr = (Map.Entry)attrIterator.next();
                        attributes.add((String)attr.getKey(), (JsonNode)attr.getValue());
                    }
                    break;
                }
                default: {
                    attributes.add(name, value);
                }
            }
            iterator.remove();
        }
        return attributes;
    }
}

