/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.model;

public enum CityJSONVersion {
    v1_1(1, 1),
    v1_0(1, 0);

    private final int major;
    private final int minor;

    private CityJSONVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toValue() {
        return this.major + "." + this.minor;
    }

    public static CityJSONVersion min(CityJSONVersion a, CityJSONVersion b) {
        return CityJSONVersion.compare(a, b) < 0 ? a : b;
    }

    public static CityJSONVersion max(CityJSONVersion a, CityJSONVersion b) {
        return CityJSONVersion.compare(a, b) > 0 ? a : b;
    }

    public static int compare(CityJSONVersion a, CityJSONVersion b) {
        return a.major != b.major ? Integer.compare(a.major, b.major) : Integer.compare(a.minor, b.minor);
    }

    public static CityJSONVersion fromValue(String value) {
        for (CityJSONVersion v : CityJSONVersion.values()) {
            if (!v.toValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.toValue();
    }
}

