/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.vegetation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.adapter.vegetation.AbstractVegetationObjectAdapter;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.vegetation.DeprecatedPropertiesOfPlantCover;
import org.citygml4j.core.model.vegetation.PlantCover;
import org.xmlobjects.gml.model.measures.Length;

@CityJSONElements(value={@CityJSONElement(name="PlantCover", schema="CityJSON-Core", version=CityJSONVersion.v1_1), @CityJSONElement(name="PlantCover", schema="CityJSON-Core", version=CityJSONVersion.v1_0)})
public class PlantCoverAdapter
extends AbstractVegetationObjectAdapter<PlantCover> {
    private final Map<CityJSONVersion, EnumSet<GeometryType>> allowedTypes = new EnumMap<CityJSONVersion, EnumSet<GeometryType>>(CityJSONVersion.class);

    public PlantCoverAdapter() {
        this.allowedTypes.put(CityJSONVersion.v1_1, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID, GeometryType.MULTI_SOLID));
        this.allowedTypes.put(CityJSONVersion.v1_0, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.MULTI_SOLID));
    }

    @Override
    public PlantCover createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new PlantCover();
    }

    @Override
    public void buildObject(PlantCover object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode maxHeight;
        JsonNode minHeight;
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        JsonNode averageHeight = attributes.consume("averageHeight");
        if (averageHeight.isNumber()) {
            object.setAverageHeight(new Length(Double.valueOf(averageHeight.asDouble()), "m"));
        }
        if ((minHeight = attributes.consume("minHeight")).isNumber()) {
            object.setMinHeight(new Length(Double.valueOf(minHeight.asDouble()), "m"));
        }
        if ((maxHeight = attributes.consume("maxHeight")).isNumber()) {
            object.setMaxHeight(new Length(Double.valueOf(maxHeight.asDouble()), "m"));
        }
    }

    @Override
    public String createType(PlantCover object, CityJSONVersion version) throws CityJSONSerializeException {
        return "PlantCover";
    }

    @Override
    public void writeObject(PlantCover object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.getAverageHeight() != null && object.getAverageHeight().getValue() != null) {
            attributes.put("averageHeight", object.getAverageHeight().getValue());
        }
        if (object.getMinHeight() != null && object.getMinHeight().getValue() != null) {
            attributes.put("minHeight", object.getMinHeight().getValue());
        }
        if (object.getMaxHeight() != null && object.getMaxHeight().getValue() != null) {
            attributes.put("maxHeight", object.getMaxHeight().getValue());
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes.get((Object)version);
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(PlantCover object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfPlantCover properties = object.getDeprecatedProperties();
            return Map.of(1, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfPlantCover)properties).getLod1MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfPlantCover)properties).setLod1MultiSurface(arg_0)), 4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfPlantCover)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfPlantCover)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

