/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.tunnel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.construction.AbstractConstructionAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.construction.RelationToConstruction;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.tunnel.DeprecatedPropertiesOfAbstractTunnel;
import org.citygml4j.core.model.tunnel.AbstractTunnel;
import org.citygml4j.core.model.tunnel.HollowSpace;
import org.citygml4j.core.model.tunnel.HollowSpaceProperty;
import org.citygml4j.core.model.tunnel.TunnelConstructiveElement;
import org.citygml4j.core.model.tunnel.TunnelConstructiveElementProperty;
import org.citygml4j.core.model.tunnel.TunnelFurniture;
import org.citygml4j.core.model.tunnel.TunnelFurnitureProperty;
import org.citygml4j.core.model.tunnel.TunnelInstallation;
import org.citygml4j.core.model.tunnel.TunnelInstallationProperty;

public abstract class AbstractTunnelAdapter<T extends AbstractTunnel>
extends AbstractConstructionAdapter<T> {
    private final Map<CityJSONVersion, EnumSet<GeometryType>> allowedTypes = new EnumMap<CityJSONVersion, EnumSet<GeometryType>>(CityJSONVersion.class);

    public AbstractTunnelAdapter() {
        this.allowedTypes.put(CityJSONVersion.v1_1, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
        this.allowedTypes.put(CityJSONVersion.v1_0, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
    }

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        Iterator children = node.path("children").elements();
        block12: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "TunnelInstallation": {
                    object.getTunnelInstallations().add(new TunnelInstallationProperty(helper.getCityObject(child, TunnelInstallation.class)));
                    break;
                }
                case "TunnelConstructiveElement": {
                    object.getTunnelConstructiveElements().add(new TunnelConstructiveElementProperty(helper.getCityObject(child, TunnelConstructiveElement.class)));
                    break;
                }
                case "TunnelHollowSpace": {
                    object.getHollowSpaces().add(new HollowSpaceProperty(helper.getCityObject(child, HollowSpace.class)));
                    break;
                }
                case "TunnelFurniture": {
                    object.getTunnelFurniture().add(new TunnelFurnitureProperty(helper.getCityObject(child, TunnelFurniture.class)));
                    break;
                }
                default: {
                    continue block12;
                }
            }
            children.remove();
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        CityJSONVersion version = helper.getVersion();
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetTunnelInstallations()) {
            for (TunnelInstallationProperty property : object.getTunnelInstallations()) {
                if (!property.isSetInlineObject() || version == CityJSONVersion.v1_0 && ((TunnelInstallation)property.getObject()).getRelationToConstruction() != RelationToConstruction.OUTSIDE) continue;
                helper.writeChildObject((TunnelInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (version == CityJSONVersion.v1_1) {
            if (object.isSetTunnelConstructiveElements()) {
                for (TunnelInstallationProperty property : object.getTunnelConstructiveElements()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((TunnelConstructiveElement)property.getObject(), (AbstractFeature)object, node);
                }
            }
            if (object.isSetHollowSpaces()) {
                for (TunnelInstallationProperty property : object.getHollowSpaces()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((HollowSpace)property.getObject(), (AbstractFeature)object, node);
                }
            }
            if (object.isSetTunnelFurniture()) {
                for (TunnelInstallationProperty property : object.getTunnelFurniture()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((TunnelFurniture)property.getObject(), (AbstractFeature)object, node);
                }
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes.get((Object)version);
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(T object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfAbstractTunnel properties = object.getDeprecatedProperties();
            return Map.of(1, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractTunnel)properties).getLod1MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractTunnel)properties).setLod1MultiSurface(arg_0)), 4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractTunnel)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractTunnel)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

