/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.transportation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.citygml4j.cityjson.adapter.transportation.AbstractTransportationSpaceAdapter;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.transportation.Intersection;
import org.citygml4j.core.model.transportation.IntersectionProperty;
import org.citygml4j.core.model.transportation.Section;
import org.citygml4j.core.model.transportation.SectionProperty;
import org.citygml4j.core.model.transportation.Track;
import org.xmlobjects.gml.model.basictypes.Code;

@CityJSONElements(value={@CityJSONElement(name="Track", schema="CityJSON-Core", version=CityJSONVersion.v1_1), @CityJSONElement(name="Track", schema="CityJSON-Core", version=CityJSONVersion.v1_0)})
public class TrackAdapter
extends AbstractTransportationSpaceAdapter<Track> {
    @Override
    public Track createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new Track();
    }

    @Override
    public void buildObject(Track object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        attributes.consume("class");
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        Iterator children = node.path("children").elements();
        while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            ObjectNode childNode = helper.getCityObjectNode(child);
            String type = childNode.path("type").asText();
            if (!"Road".equals(type) && !"Track".equals(type)) continue;
            String classifier = childNode.path("attributes").path("class").asText();
            if ("Section".equalsIgnoreCase(classifier)) {
                Track section = helper.getCityObject(child, Track.class);
                object.getSections().add(new SectionProperty(this.shallowCopy(section, new Section())));
            } else if ("Intersection".equalsIgnoreCase(classifier)) {
                Track intersection = helper.getCityObject(child, Track.class);
                object.getIntersections().add(new IntersectionProperty(this.shallowCopy(intersection, new Intersection())));
            } else {
                helper.buildAsTopLevelObject(child);
            }
            children.remove();
        }
    }

    @Override
    public String createType(Track object, CityJSONVersion version) throws CityJSONSerializeException {
        return "Road";
    }

    @Override
    public void writeObject(Track object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        Track section;
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        object.setClassifier(new Code("Track"));
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetSections()) {
            for (SectionProperty property : object.getSections()) {
                if (property.getObject() == null) continue;
                section = this.shallowCopy((Section)property.getObject(), new Track());
                section.setClassifier(new Code("Section"));
                helper.writeChildObject(section, (AbstractFeature)object, node);
            }
        }
        if (object.isSetIntersections()) {
            for (SectionProperty property : object.getIntersections()) {
                if (property.getObject() == null) continue;
                section = this.shallowCopy((Intersection)property.getObject(), new Track());
                section.setClassifier(new Code("Intersection"));
                helper.writeChildObject(section, (AbstractFeature)object, node);
            }
        }
    }
}

