/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.model.geometry.Transform;
import org.citygml4j.cityjson.model.geometry.Vertex;
import org.citygml4j.cityjson.util.ArrayBuffer;

public class VerticesBuilder {
    private Map<String, Integer> indexes = new HashMap<String, Integer>();
    private ArrayBuffer<Vertex> vertices = new ArrayBuffer();
    private int precision;
    private Vertex translation;

    VerticesBuilder(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        if (precision >= 0) {
            this.precision = precision;
        }
    }

    public Vertex getTranslation() {
        return this.translation;
    }

    public void setTranslation(Vertex translation) {
        this.translation = translation;
    }

    public List<Integer> addVertices(List<Double> vertices) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(vertices.size() / 3);
        int size = vertices.size();
        for (int i = 0; i < size && i + 3 <= size; i += 3) {
            double x = this.round(vertices.get(i));
            double y = this.round(vertices.get(i + 1));
            double z = this.round(vertices.get(i + 2));
            String key = Double.toString(x) + y + z;
            Integer index = this.indexes.get(key);
            if (index == null) {
                index = this.vertices.size();
                this.vertices.add(Vertex.of(x, y, z));
                this.indexes.put(key, index);
            }
            indexes.add(index);
        }
        return indexes;
    }

    public Transform transform() {
        if (this.translation == null) {
            this.translation = Vertex.of(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            for (Vertex vertex : this.vertices) {
                if (vertex.getX() < this.translation.getX()) {
                    this.translation.setX(vertex.getX());
                }
                if (vertex.getY() < this.translation.getY()) {
                    this.translation.setY(vertex.getY());
                }
                if (!(vertex.getZ() < this.translation.getZ())) continue;
                this.translation.setZ(vertex.getZ());
            }
        }
        double scale = Math.pow(10.0, this.precision);
        long[] offset = new long[]{(long)(this.translation.getX() * scale), (long)(this.translation.getY() * scale), (long)(this.translation.getZ() * scale)};
        for (Vertex vertex : this.vertices) {
            vertex.setX((long)(vertex.getX() * scale) - offset[0]);
            vertex.setY((long)(vertex.getY() * scale) - offset[1]);
            vertex.setZ((long)(vertex.getZ() * scale) - offset[2]);
        }
        scale = 1.0 / scale;
        Transform transform = new Transform();
        transform.setTranslate(this.translation);
        transform.setScale(Vertex.of(scale, scale, scale));
        return transform;
    }

    public ArrayBuffer<Vertex> build() {
        this.indexes.clear();
        return this.vertices;
    }

    public void reset() {
        this.indexes = new HashMap<String, Integer>();
        this.vertices = new ArrayBuffer();
    }

    public double round(double value) {
        return BigDecimal.valueOf(value).setScale(this.precision, RoundingMode.HALF_UP).doubleValue();
    }
}

