/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.function.BiConsumer;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.visitor.GeometryWalker;

public abstract class GeometryBuilder
extends GeometryWalker {
    final CityJSONSerializerHelper helper;
    private final BiConsumer<Number, ObjectNode> lodSetter;

    GeometryBuilder(CityJSONSerializerHelper helper) {
        this.helper = helper;
        this.lodSetter = helper.getVersion() == CityJSONVersion.v1_0 ? this::setLodAsNumber : this::setLodAsString;
    }

    abstract JsonNode build(AbstractGeometry var1, Number var2);

    abstract int size();

    void setLod(Number lod, ObjectNode node) {
        this.lodSetter.accept(lod, node);
    }

    private void setLodAsString(Number lod, ObjectNode node) {
        if (lod instanceof Integer) {
            node.put("lod", String.valueOf(lod.intValue()));
        } else {
            node.put("lod", String.valueOf(lod.doubleValue()));
        }
    }

    private void setLodAsNumber(Number lod, ObjectNode node) {
        if (lod instanceof Integer) {
            node.put("lod", lod.intValue());
        } else {
            node.put("lod", lod.doubleValue());
        }
    }
}

