/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObjectBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SurfaceGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SurfaceProvider;
import org.citygml4j.cityjson.adapter.geometry.builder.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSolid;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSolid;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSolid;
import org.xmlobjects.gml.model.geometry.primitives.Shell;
import org.xmlobjects.gml.model.geometry.primitives.ShellProperty;
import org.xmlobjects.gml.model.geometry.primitives.Solid;
import org.xmlobjects.gml.model.geometry.primitives.SolidProperty;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;

public class SolidGeometryBuilder
extends GeometryObjectBuilder
implements SurfaceProvider {
    private final SurfaceGeometryBuilder surfaceGeometryBuilder;
    private final List<SurfaceProperty> surfaces = new ArrayList<SurfaceProperty>();

    SolidGeometryBuilder(AbstractFeature object, BoundaryFilter filter, VerticesBuilder verticesBuilder) {
        super(object, filter);
        this.surfaceGeometryBuilder = new SurfaceGeometryBuilder(object, filter, verticesBuilder);
    }

    @Override
    void build(JsonNode node, GeometryType type, int lod, GeometryObject geometryObject) {
        JsonNode boundaries = node.path("boundaries");
        if (boundaries.isArray()) {
            Solid geometry = null;
            switch (type) {
                case SOLID: {
                    geometry = this.createSolid((ArrayNode)boundaries);
                    break;
                }
                case COMPOSITE_SOLID: {
                    geometry = this.createCompositeSolid((ArrayNode)boundaries);
                    break;
                }
                case MULTI_SOLID: {
                    geometry = this.createMultiSolid((ArrayNode)boundaries);
                }
            }
            if (geometry != null) {
                geometryObject.setGeometry((AbstractGeometry)geometry);
            } else {
                this.surfaces.clear();
            }
        }
    }

    @Override
    public List<SurfaceProperty> getSurfaces() {
        return this.surfaces;
    }

    private Solid createSolid(ArrayNode shells) {
        List<SurfaceProperty> surfaces;
        JsonNode shell = shells.path(0);
        if (shell.isArray() && (surfaces = this.surfaceGeometryBuilder.buildSurfaces((ArrayNode)shell)) != null) {
            Solid solid = new Solid(new Shell(surfaces));
            this.surfaces.addAll(surfaces);
            for (int i = 1; i < shells.size(); ++i) {
                shell = shells.get(i);
                List<SurfaceProperty> list = surfaces = shell.isArray() ? this.surfaceGeometryBuilder.buildSurfaces((ArrayNode)shell) : null;
                if (surfaces == null) {
                    return null;
                }
                solid.getInterior().add(new ShellProperty(new Shell(surfaces)));
                this.surfaces.addAll(surfaces);
            }
            return solid;
        }
        return null;
    }

    private AbstractSolid createCompositeSolid(ArrayNode solids) {
        if (!solids.isEmpty()) {
            CompositeSolid compositeSolid = new CompositeSolid();
            for (JsonNode shells : solids) {
                Solid solid;
                Solid solid2 = solid = shells.isArray() ? this.createSolid((ArrayNode)shells) : null;
                if (solid != null) {
                    compositeSolid.getSolidMembers().add(new SolidProperty((AbstractSolid)solid));
                    continue;
                }
                return null;
            }
            return compositeSolid.getSolidMembers().size() > 1 ? compositeSolid : (AbstractSolid)((SolidProperty)compositeSolid.getSolidMembers().get(0)).getObject();
        }
        return null;
    }

    private AbstractGeometry createMultiSolid(ArrayNode solids) {
        if (!solids.isEmpty()) {
            MultiSolid multiSolid = new MultiSolid();
            for (JsonNode shells : solids) {
                Solid solid;
                Solid solid2 = solid = shells.isArray() ? this.createSolid((ArrayNode)shells) : null;
                if (solid != null) {
                    multiSolid.getSolidMember().add(new SolidProperty((AbstractSolid)solid));
                    continue;
                }
                return null;
            }
            return multiSolid.getSolidMember().size() > 1 ? multiSolid : ((SolidProperty)multiSolid.getSolidMember().get(0)).getObject();
        }
        return null;
    }
}

