/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObjectBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.DirectPositionList;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurve;
import org.xmlobjects.gml.model.geometry.primitives.AbstractCurve;
import org.xmlobjects.gml.model.geometry.primitives.CurveProperty;
import org.xmlobjects.gml.model.geometry.primitives.LineString;

public class CurveGeometryBuilder
extends GeometryObjectBuilder {
    private final VerticesBuilder verticesBuilder;

    CurveGeometryBuilder(AbstractFeature object, BoundaryFilter filter, VerticesBuilder verticesBuilder) {
        super(object, filter);
        this.verticesBuilder = verticesBuilder;
    }

    @Override
    void build(JsonNode node, GeometryType type, int lod, GeometryObject geometryObject) {
        JsonNode boundaries = node.path("boundaries");
        if (boundaries.isArray()) {
            geometryObject.setGeometry((AbstractGeometry)this.createMultiCurve((ArrayNode)boundaries));
        }
    }

    private LineString createLineString(ArrayNode points) {
        List<Double> vertices = this.verticesBuilder.getVertices(points, false);
        if (!vertices.isEmpty()) {
            DirectPositionList posList = new DirectPositionList(vertices);
            posList.setSrsDimension(Integer.valueOf(3));
            return new LineString(posList);
        }
        return null;
    }

    private MultiCurve createMultiCurve(ArrayNode curves) {
        if (!curves.isEmpty()) {
            MultiCurve multiCurve = new MultiCurve();
            for (JsonNode points : curves) {
                LineString lineString;
                LineString lineString2 = lineString = points.isArray() ? this.createLineString((ArrayNode)points) : null;
                if (lineString != null) {
                    multiCurve.getCurveMember().add(new CurveProperty((AbstractCurve)lineString));
                    continue;
                }
                return null;
            }
            return multiCurve;
        }
        return null;
    }
}

