/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.address.AdministrativeAreaAdapter;
import org.citygml4j.cityjson.adapter.address.CountryAdapter;
import org.citygml4j.cityjson.adapter.address.FreeTextAddressAdapter;
import org.citygml4j.cityjson.adapter.address.LocalityAdapter;
import org.citygml4j.cityjson.adapter.address.PostCodeAdapter;
import org.citygml4j.cityjson.adapter.address.PostOfficeAdapter;
import org.citygml4j.cityjson.adapter.address.PostalDeliveryPointAdapter;
import org.citygml4j.cityjson.adapter.address.PremisesAdapter;
import org.citygml4j.cityjson.adapter.address.RuralDeliveryAdapter;
import org.citygml4j.cityjson.adapter.address.ThoroughfareAdapter;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.model.address.AddressType;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.Address;
import org.citygml4j.core.model.core.XALAddressProperty;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiPoint;
import org.xmlobjects.gml.model.geometry.aggregates.MultiPointProperty;
import org.xmlobjects.xal.model.AdministrativeArea;
import org.xmlobjects.xal.model.Country;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.RuralDelivery;
import org.xmlobjects.xal.model.Thoroughfare;

public class AddressAdapter
implements JsonObjectBuilder<Address>,
JsonObjectSerializer<Address> {
    @Override
    public Address createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new Address();
    }

    @Override
    public void buildObject(Address object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        GeometryObject geometryObject;
        org.xmlobjects.xal.model.Address address = new org.xmlobjects.xal.model.Address();
        JsonNode location = helper.consumeProperty("location", node);
        if (location.isObject() && (geometryObject = helper.getGeometry((AbstractFeature)object, location)).getGeometry() instanceof MultiPoint) {
            object.setMultiPoint(new MultiPointProperty((MultiPoint)geometryObject.getGeometry()));
        }
        HashMap<AddressType, ObjectNode> properties = new HashMap<AddressType, ObjectNode>();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            AddressType type = AddressType.fromPropertyName((String)entry.getKey());
            properties.computeIfAbsent(type, v -> helper.createObject()).set((String)entry.getKey(), (JsonNode)entry.getValue());
        }
        block12: for (Map.Entry entry : properties.entrySet()) {
            switch ((AddressType)((Object)entry.getKey())) {
                case ADMINISTRATIVE_AREA: {
                    address.setAdministrativeArea((AdministrativeArea)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), AdministrativeAreaAdapter.class));
                    continue block12;
                }
                case COUNTRY: {
                    address.setCountry((Country)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), CountryAdapter.class));
                    continue block12;
                }
                case LOCALITY: {
                    address.setLocality((Locality)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), LocalityAdapter.class));
                    continue block12;
                }
                case POSTAL_DELIVERY_POINT: {
                    address.setPostalDeliveryPoint((PostalDeliveryPoint)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), PostalDeliveryPointAdapter.class));
                    continue block12;
                }
                case POST_CODE: 
                case POSTAL_CODE: {
                    address.setPostCode((PostCode)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), PostCodeAdapter.class));
                }
                case POST_OFFICE: {
                    address.setPostOffice((PostOffice)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), PostOfficeAdapter.class));
                    continue block12;
                }
                case PREMISES: {
                    address.setPremises((Premises)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), PremisesAdapter.class));
                    continue block12;
                }
                case RURAL_DELIVERY: {
                    address.setRuralDelivery((RuralDelivery)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), RuralDeliveryAdapter.class));
                    continue block12;
                }
                case THOROUGHFARE: {
                    address.setThoroughfare((Thoroughfare)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), ThoroughfareAdapter.class));
                    continue block12;
                }
            }
            address.setFreeTextAddress((FreeTextAddress)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), FreeTextAddressAdapter.class));
        }
        object.setXALAddress(new XALAddressProperty(address));
    }

    @Override
    public void writeObject(Address object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        if (object.getXALAddress() != null && object.getXALAddress().getObject() != null) {
            ObjectNode location;
            org.xmlobjects.xal.model.Address address = (org.xmlobjects.xal.model.Address)object.getXALAddress().getObject();
            if (address.getFreeTextAddress() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getFreeTextAddress(), FreeTextAddressAdapter.class));
            }
            if (address.getCountry() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getCountry(), CountryAdapter.class));
            }
            if (address.getAdministrativeArea() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getAdministrativeArea(), AdministrativeAreaAdapter.class));
            }
            if (address.getLocality() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getLocality(), LocalityAdapter.class));
            }
            if (address.getThoroughfare() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getThoroughfare(), ThoroughfareAdapter.class));
            }
            if (address.getPremises() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getPremises(), PremisesAdapter.class));
            }
            if (address.getPostCode() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getPostCode(), PostCodeAdapter.class));
            }
            if (address.getRuralDelivery() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getRuralDelivery(), RuralDeliveryAdapter.class));
            }
            if (address.getPostalDeliveryPoint() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getPostalDeliveryPoint(), PostalDeliveryPointAdapter.class));
            }
            if (address.getPostOffice() != null) {
                node.setAll(helper.getObjectUsingSerializer(address.getPostOffice(), PostOfficeAdapter.class));
            }
            if (object.getMultiPoint() != null && (location = helper.getGeometry((GeometryProperty<?>)object.getMultiPoint(), (Number)1, EnumSet.of(GeometryType.MULTI_POINT))) != null && !location.isEmpty()) {
                node.set("location", (JsonNode)location);
            }
        }
    }
}

