/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.OffsetDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import org.citygml4j.cityjson.adapter.core.AbstractFeatureAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.AbstractFeatureWithLifespan;

public abstract class AbstractFeatureWithLifespanAdapter<T extends AbstractFeatureWithLifespan>
extends AbstractFeatureAdapter<T> {
    private DateTimeFormatter dateTimeParser;

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode validTo;
        JsonNode validFrom;
        JsonNode terminationDate;
        super.buildObject(object, attributes, node, parent, helper);
        JsonNode creationDate = attributes.consume("creationDate");
        if (creationDate.isTextual()) {
            object.setCreationDate(this.toOffsetDateTime(creationDate.asText()));
        }
        if ((terminationDate = attributes.consume("terminationDate")).isTextual()) {
            object.setTerminationDate(this.toOffsetDateTime(terminationDate.asText()));
        }
        if ((validFrom = attributes.consume("validFrom")).isTextual()) {
            object.setValidFrom(this.toOffsetDateTime(validFrom.asText()));
        }
        if ((validTo = attributes.consume("validTo")).isTextual()) {
            object.setValidTo(this.toOffsetDateTime(validTo.asText()));
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        CityJSONVersion version = helper.getVersion();
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        if (object.getCreationDate() != null) {
            attributes.put("creationDate", object.getCreationDate().format(this.getDateTimeFormatter(version)));
        }
        if (object.getTerminationDate() != null) {
            attributes.put("terminationDate", object.getTerminationDate().format(this.getDateTimeFormatter(version)));
        }
        if (object.getValidFrom() != null) {
            attributes.put("validFrom", object.getValidFrom().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (object.getValidTo() != null) {
            attributes.put("validTo", object.getValidTo().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    private DateTimeFormatter getDateTimeFormatter(CityJSONVersion version) {
        return version == CityJSONVersion.v1_0 ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    }

    private OffsetDateTime toOffsetDateTime(String dateTime) {
        try {
            if (this.dateTimeParser == null) {
                this.dateTimeParser = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalEnd().optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
            }
            return OffsetDateTime.parse(dateTime, this.dateTimeParser);
        }
        catch (Exception e) {
            return null;
        }
    }
}

