/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.adapter.core.AbstractFeatureWithLifespanAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONType;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.cityobjectgroup.CityObjectGroup;
import org.citygml4j.core.model.cityobjectgroup.Role;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractGenericAttribute;
import org.citygml4j.core.model.core.AbstractGenericAttributeProperty;
import org.citygml4j.core.model.core.RelativeToTerrain;
import org.citygml4j.core.model.core.RelativeToWater;
import org.citygml4j.core.util.reference.Referees;
import org.xmlobjects.gml.model.base.AbstractGML;

public abstract class AbstractCityObjectAdapter<T extends AbstractCityObject>
extends AbstractFeatureWithLifespanAdapter<T> {
    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode relativeToWater;
        super.buildObject(object, attributes, node, parent, helper);
        JsonNode relativeToTerrain = attributes.consume("relativeToTerrain");
        if (relativeToTerrain.isTextual()) {
            object.setRelativeToTerrain(RelativeToTerrain.fromValue((String)relativeToTerrain.asText()));
        }
        if ((relativeToWater = attributes.consume("relativeToWater")).isTextual()) {
            object.setRelativeToWater(RelativeToWater.fromValue((String)relativeToWater.asText()));
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        Referees referees;
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        if (object.getRelativeToTerrain() != null) {
            attributes.put("relativeToTerrain", object.getRelativeToTerrain().toValue());
        }
        if (object.getRelativeToWater() != null) {
            attributes.put("relativeToWater", object.getRelativeToWater().toValue());
        }
        if (object.hasLocalProperties() && helper.getVersion() != CityJSONVersion.v1_0 && helper.getType() != CityJSONType.CITYJSON_FEATURE && (referees = (Referees)object.getLocalProperties().get(Referees.PROPERTY_NAME, Referees.class)) != null) {
            for (Role role : referees.get(Role.class)) {
                CityObjectGroup group = (CityObjectGroup)role.getParent(CityObjectGroup.class);
                if (group == null) continue;
                helper.getOrPutArray("parents", node).add(helper.getOrCreateId((AbstractGML)group));
            }
        }
        if (object.isSetGenericAttributes()) {
            for (AbstractGenericAttributeProperty property : object.getGenericAttributes()) {
                JsonObjectSerializer<?> serializer;
                if (property.getObject() == null || (serializer = helper.getContext().getSerializer(((AbstractGenericAttribute)property.getObject()).getClass(), helper.getVersion())) == null) continue;
                serializer.writeObject((AbstractGenericAttribute)property.getObject(), attributes, helper);
            }
        }
    }
}

