/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.appearance.builder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.adapter.appearance.ParameterizedTextureAdapter;
import org.citygml4j.cityjson.adapter.appearance.X3DMaterialAdapter;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceInfo;
import org.citygml4j.cityjson.adapter.appearance.builder.TextureVerticesBuilder;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.core.model.appearance.AbstractSurfaceData;
import org.citygml4j.core.model.appearance.AbstractSurfaceDataProperty;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.X3DMaterial;

public class AppearanceBuilder {
    private final CityJSONBuilderHelper helper;
    private final ArrayNode materials;
    private final ArrayNode textures;
    private final TextureVerticesBuilder textureVerticesBuilder;

    public AppearanceBuilder(ObjectNode appearance, CityJSONBuilderHelper helper) {
        this.helper = helper;
        this.materials = helper.getOrPutArray("materials", appearance);
        this.textures = helper.getOrPutArray("textures", appearance);
        this.textureVerticesBuilder = new TextureVerticesBuilder(helper.getOrPutArray("vertices-texture", appearance));
    }

    public TextureVerticesBuilder getTextureVerticesBuilder() {
        return this.textureVerticesBuilder;
    }

    public X3DMaterial getOrCreateMaterial(int index, String theme, AppearanceInfo appearanceInfo) {
        X3DMaterial material = appearanceInfo.getMaterial(index);
        if (material == null) {
            try {
                material = (X3DMaterial)this.helper.getObjectUsingBuilder(this.materials.get(index), X3DMaterialAdapter.class);
                this.addToAppearance((AbstractSurfaceData)material, theme, appearanceInfo);
                appearanceInfo.addMaterial(index, material);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return material;
    }

    public ParameterizedTexture getOrCreateTexture(int index, String theme, AppearanceInfo appearanceInfo) {
        ParameterizedTexture texture = appearanceInfo.getTexture(index);
        if (texture == null) {
            try {
                texture = (ParameterizedTexture)this.helper.getObjectUsingBuilder(this.textures.get(index), ParameterizedTextureAdapter.class);
                this.addToAppearance((AbstractSurfaceData)texture, theme, appearanceInfo);
                appearanceInfo.addTexture(index, texture);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return texture;
    }

    private void addToAppearance(AbstractSurfaceData surfaceData, String theme, AppearanceInfo appearanceInfo) {
        Appearance appearance = appearanceInfo.getAppearance(theme);
        if (appearance == null) {
            appearance = new Appearance();
            appearance.setTheme(!theme.isEmpty() ? theme : null);
            appearanceInfo.addAppearance(theme, appearance);
        }
        appearance.getSurfaceData().add(new AbstractSurfaceDataProperty(surfaceData));
    }
}

