/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes.actions;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.kubernetes.actions.AbstractKubernetesAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchPodLogsAction
extends AbstractKubernetesAction {
    private static final Logger LOG = LoggerFactory.getLogger(WatchPodLogsAction.class);
    private static final Logger POD_LOG = LoggerFactory.getLogger((String)"POD_LOGS");
    private final String podName;
    private final String labelExpression;
    private final String timeout;
    private final TimeUnit timeUnit;

    public WatchPodLogsAction(Builder builder) {
        super("watch-pod-logs", builder);
        this.podName = builder.podName;
        this.labelExpression = builder.labelExpression;
        this.timeout = builder.timeout;
        this.timeUnit = builder.timeUnit;
    }

    public void doExecute(TestContext context) {
        String resolvedPodName = context.replaceDynamicContentInString(this.podName);
        String resolvedLabelExpression = context.replaceDynamicContentInString(this.labelExpression);
        Pod pod = resolvedPodName != null && !resolvedPodName.isEmpty() ? this.getPod(resolvedPodName, this.namespace(context)) : this.getPodFromLabel(resolvedLabelExpression, this.namespace(context));
        String containerName = null;
        if (pod.getSpec() != null && pod.getSpec().getContainers() != null && pod.getSpec().getContainers().size() > 1) {
            containerName = ((Container)pod.getSpec().getContainers().get(0)).getName();
        }
        PodResource podRes = (PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(this.namespace(context))).withName(pod.getMetadata().getName());
        LogWatch logs = containerName != null ? ((ContainerResource)podRes.inContainer((Object)containerName)).watchLog() : podRes.watchLog();
        long stoppingAt = System.currentTimeMillis() + this.getDurationMillis();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(logs.getOutput()));){
            String line;
            while (stoppingAt - System.currentTimeMillis() > 0L && (line = reader.readLine()) != null) {
                POD_LOG.info(line);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read pod logs", (Throwable)e);
        }
    }

    private long getDurationMillis() {
        if (this.timeout.indexOf(".") > 0) {
            switch (this.timeUnit) {
                case MILLISECONDS: {
                    return Math.round(Double.parseDouble(this.timeout));
                }
                case SECONDS: {
                    return Math.round(Double.parseDouble(this.timeout) * 1000.0);
                }
                case MINUTES: {
                    return Math.round(Double.parseDouble(this.timeout) * 60.0 * 1000.0);
                }
            }
            throw new CitrusRuntimeException("Unsupported time expression for watch pod log action - please use one of milliseconds, seconds, minutes");
        }
        switch (this.timeUnit) {
            case MILLISECONDS: {
                return Long.parseLong(this.timeout);
            }
            case SECONDS: {
                return Long.parseLong(this.timeout) * 1000L;
            }
            case MINUTES: {
                return Long.parseLong(this.timeout) * 60L * 1000L;
            }
        }
        throw new CitrusRuntimeException("Unsupported time expression for watch pod log action - please use one of milliseconds, seconds, minutes");
    }

    private Pod getPod(String name, String namespace) {
        return (Pod)((PodResource)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withName(name)).get();
    }

    private Pod getPodFromLabel(String labelExpression, String namespace) {
        if (labelExpression == null || labelExpression.isEmpty()) {
            return null;
        }
        String[] tokens = labelExpression.split("=");
        String labelKey = tokens[0];
        String labelValue = tokens.length > 1 ? tokens[1] : "";
        PodList pods = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(namespace)).withLabel(labelKey, labelValue)).list();
        return pods.getItems().stream().findFirst().orElse(null);
    }

    public static final class Builder
    extends AbstractKubernetesAction.Builder<WatchPodLogsAction, Builder> {
        private String podName;
        private String labelExpression;
        private String timeout = "60000";
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder label(String name, String value) {
            this.labelExpression = String.format("%s=%s", name, value);
            return this;
        }

        public Builder milliseconds(String time) {
            this.timeout = time;
            this.timeUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public Builder seconds(String time) {
            this.timeout = time;
            this.timeUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder minutes(String time) {
            this.timeout = time;
            this.timeUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder timeout(Duration duration) {
            this.timeout = String.valueOf(duration.toMillis());
            this.timeUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public WatchPodLogsAction build() {
            return new WatchPodLogsAction(this);
        }
    }
}

