/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import org.citrusframework.Citrus;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.KnativeVariableNames;
import org.citrusframework.yaks.knative.ce.CloudEventMessage;
import org.citrusframework.yaks.knative.ce.CloudEventSupport;
import org.citrusframework.yaks.kubernetes.KubernetesSteps;
import org.springframework.http.HttpStatus;

public class ReceiveEventSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    @CitrusFramework
    private Citrus citrus;
    private String eventData;
    private KubernetesSteps kubernetesSteps;

    @Before
    public void before(Scenario scenario) {
        this.kubernetesSteps = new KubernetesSteps();
        CitrusAnnotations.injectAll((Object)this.kubernetesSteps, (Citrus)this.citrus, (TestContext)this.context);
        CitrusAnnotations.injectTestRunner((Object)this.kubernetesSteps, (TestCaseRunner)this.runner);
        this.kubernetesSteps.before(scenario);
        this.kubernetesSteps.configureTimeout(KnativeSettings.getEventConsumerTimeout());
        this.kubernetesSteps.setServiceName(KnativeSettings.getServiceName());
        this.kubernetesSteps.setServicePort(KnativeSettings.getServicePort());
    }

    @Given(value="^Knative service \"([^\"\\s]+)\"$")
    public void setServiceName(String name) {
        this.kubernetesSteps.setServiceName(name);
    }

    @Given(value="^Knative service port ([^\\s]+)$")
    public void setServicePort(String port) {
        this.kubernetesSteps.setServicePort(port);
    }

    @Given(value="^Knative event consumer timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.kubernetesSteps.configureTimeout(timeout);
    }

    @Given(value="^(?:expect|verify) Knative event data$")
    public void setEventDataMultiline(String data) {
        this.setEventData(data);
    }

    @Given(value="^(?:expect|verify) Knative event data: (.+)$")
    public void setEventData(String data) {
        this.eventData = data;
    }

    @Then(value="^(?:receive|verify) Knative event$")
    public void receiveEvent(DataTable attributes) {
        this.receiveEvent(CloudEventSupport.createEventMessage(this.eventData, attributes.asMap(String.class, String.class)));
    }

    @Then(value="^(?:receive|verify) Knative event as json$")
    public void receiveEventJson(String json) {
        this.receiveEvent(CloudEventSupport.createEventMessage(this.eventData, CloudEventSupport.attributesFromJson(json)));
    }

    @Given(value="^create Knative event consumer service ([^\\s]+)$")
    public void createService(String serviceName) {
        if (YaksSettings.isLocal() && this.context.getVariables().containsKey(KnativeVariableNames.BROKER_NAME.value()) && this.context.getReferenceResolver().isResolvable(this.context.getVariable(KnativeVariableNames.BROKER_NAME.value()))) {
            HttpServer brokerServer = (HttpServer)this.context.getReferenceResolver().resolve(this.context.getVariable(KnativeVariableNames.BROKER_NAME.value()), HttpServer.class);
            this.context.getReferenceResolver().bind(serviceName, (Object)brokerServer);
            this.setServiceName(serviceName);
            this.setServicePort(String.valueOf(brokerServer.getPort()));
        } else {
            this.kubernetesSteps.createService(serviceName);
        }
    }

    @Given(value="^create Knative event consumer service ([^\\s]+) with target port ([^\\s]+)$")
    public void createService(String serviceName, String targetPort) {
        if (YaksSettings.isLocal() && this.context.getVariables().containsKey(KnativeVariableNames.BROKER_NAME.value()) && this.context.getReferenceResolver().isResolvable(this.context.getVariable(KnativeVariableNames.BROKER_NAME.value()))) {
            HttpServer brokerServer = (HttpServer)this.context.getReferenceResolver().resolve(this.context.getVariable(KnativeVariableNames.BROKER_NAME.value()), HttpServer.class);
            this.context.getReferenceResolver().bind(serviceName, (Object)brokerServer);
            this.setServiceName(serviceName);
            this.setServicePort(String.valueOf(brokerServer.getPort()));
        } else {
            this.kubernetesSteps.createService(serviceName, targetPort);
        }
    }

    private void receiveEvent(CloudEventMessage request) {
        this.kubernetesSteps.receiveServiceRequest((HttpMessage)request);
        this.kubernetesSteps.sendServiceResponse(HttpStatus.ACCEPTED);
    }
}

