/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.KnativeVariableNames;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class KnativeSteps {
    @CitrusResource
    private TestCaseRunner runner;
    private String namespace = KnativeSettings.getNamespace();
    @CitrusFramework
    private Citrus citrus;
    private KubernetesClient k8sClient;
    protected static boolean autoRemoveResources = KnativeSettings.isAutoRemoveResources();

    @Before
    public void before(Scenario scenario) {
        this.runner.variable(KnativeVariableNames.NAMESPACE.value(), (Object)this.namespace);
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
    }

    @Given(value="^Disable auto removal of Knative resources$")
    public void disableAutoRemove() {
        autoRemoveResources = false;
    }

    @Given(value="^Enable auto removal of Knative resources$")
    public void enableAutoRemove() {
        autoRemoveResources = true;
    }

    @Given(value="^Knative namespace ([^\\s]+)$")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)KnativeVariableNames.NAMESPACE.value(), (String)namespace));
    }
}

