/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.ce;

import java.util.Arrays;
import java.util.List;

public class CloudEvent {
    private final String version;
    private final List<Attribute> attributes;

    private CloudEvent(String version, List<Attribute> attributes) {
        this.version = version;
        this.attributes = attributes;
    }

    public String version() {
        return this.version;
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public static CloudEvent v1_0() {
        return new CloudEvent("1.0", Arrays.asList(Attribute.ID, Attribute.SOURCE, Attribute.SPEC_VERSION, Attribute.TYPE, Attribute.SUBJECT, Attribute.DATA_SCHEMA, Attribute.TIME, Attribute.CONTENT_TYPE));
    }

    public static enum Attribute {
        ID("Ce-Id", "id"),
        SOURCE("Ce-Source", "source"),
        SPEC_VERSION("Ce-Specversion", "specversion", "1.0"),
        TYPE("Ce-Type", "type"),
        SUBJECT("Ce-Subject", "subject"),
        DATA_SCHEMA("Ce-Dataschema", "dataschema"),
        TIME("Ce-Time", "time"),
        CONTENT_TYPE("Content-Type", "datacontenttype");

        private final String http;
        private final String json;
        private final String defaultValue;

        public String http() {
            return this.http;
        }

        public String json() {
            return this.json;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        private Attribute(String http, String json) {
            this(http, json, null);
        }

        private Attribute(String http, String json, String defaultValue) {
            this.http = http;
            this.json = json;
            this.defaultValue = defaultValue;
        }
    }
}

