/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions.eventing;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.knative.KnativeSupport;
import org.citrusframework.yaks.knative.actions.AbstractKnativeAction;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class DeleteBrokerAction
extends AbstractKnativeAction {
    private final String brokerName;

    public DeleteBrokerAction(Builder builder) {
        super("delete-broker", builder);
        this.brokerName = builder.brokerName;
    }

    public void doExecute(TestContext context) {
        if (YaksSettings.isLocal((YaksClusterType)this.clusterType(context))) {
            this.deleteLocalBroker(context);
        } else {
            this.deleteBroker(context);
        }
    }

    private void deleteLocalBroker(TestContext context) {
        String resolvedBrokerName = context.replaceDynamicContentInString(this.brokerName);
        if (context.getReferenceResolver().isResolvable(resolvedBrokerName, HttpServer.class)) {
            HttpServer brokerServer = (HttpServer)context.getReferenceResolver().resolve(resolvedBrokerName, HttpServer.class);
            brokerServer.stop();
        }
    }

    private void deleteBroker(TestContext context) {
        KubernetesSupport.deleteResource((KubernetesClient)this.getKubernetesClient(), (String)this.namespace(context), (ResourceDefinitionContext)KnativeSupport.knativeCRDContext("eventing", "brokers", KnativeSupport.knativeApiVersion()), (String)context.replaceDynamicContentInString(this.brokerName));
    }

    public static class Builder
    extends AbstractKnativeAction.Builder<DeleteBrokerAction, Builder> {
        private String brokerName;

        public Builder name(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public DeleteBrokerAction build() {
            return new DeleteBrokerAction(this);
        }
    }
}

