/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.KnativeVariableNames;

public interface KnativeAction
extends TestAction {
    public KubernetesClient getKubernetesClient();

    public KnativeClient getKnativeClient();

    default public String namespace(TestContext context) {
        if (context.getVariables().containsKey(KnativeVariableNames.NAMESPACE.value())) {
            return context.getVariable(KnativeVariableNames.NAMESPACE.value());
        }
        return KnativeSettings.getNamespace();
    }

    default public String brokerName(TestContext context) {
        if (context.getVariables().containsKey(KnativeVariableNames.BROKER_NAME.value())) {
            context.getVariable(KnativeVariableNames.BROKER_NAME.value());
        }
        return KnativeSettings.getBrokerName();
    }

    default public YaksClusterType clusterType(TestContext context) {
        if (context.getVariables().containsKey(KnativeVariableNames.CLUSTER_TYPE.value())) {
            Object clusterType = context.getVariableObject(KnativeVariableNames.CLUSTER_TYPE.value());
            if (clusterType instanceof YaksClusterType) {
                return (YaksClusterType)clusterType;
            }
            return YaksClusterType.valueOf((String)clusterType.toString());
        }
        return YaksSettings.getClusterType();
    }
}

