/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksClusterType;
import org.citrusframework.yaks.knative.actions.KnativeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKnativeAction
extends AbstractTestAction
implements KnativeAction {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final KnativeClient knativeClient;
    private final KubernetesClient kubernetesClient;
    private final YaksClusterType clusterType;

    public AbstractKnativeAction(String name, Builder<?, ?> builder) {
        super("knative:" + name, builder);
        this.knativeClient = builder.knativeClient;
        this.kubernetesClient = builder.kubernetesClient;
        this.clusterType = builder.clusterType;
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    @Override
    public KnativeClient getKnativeClient() {
        return this.knativeClient;
    }

    @Override
    public YaksClusterType clusterType(TestContext context) {
        if (this.clusterType != null) {
            return this.clusterType;
        }
        return KnativeAction.super.clusterType(context);
    }

    public static abstract class Builder<T extends KnativeAction, B extends Builder<T, B>>
    extends AbstractTestActionBuilder<T, B> {
        private KnativeClient knativeClient;
        private KubernetesClient kubernetesClient;
        private YaksClusterType clusterType;

        public B client(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
            return (B)((Object)((Builder)this.self));
        }

        public B client(KnativeClient knativeClient) {
            this.knativeClient = knativeClient;
            return (B)((Object)((Builder)this.self));
        }

        public B clusterType(YaksClusterType clusterType) {
            this.clusterType = clusterType;
            return (B)((Object)((Builder)this.self));
        }
    }
}

