/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions.eventing;

import io.fabric8.knative.eventing.v1.Trigger;
import io.fabric8.knative.eventing.v1.TriggerBuilder;
import io.fabric8.knative.eventing.v1.TriggerFluent;
import io.fabric8.knative.eventing.v1.TriggerSpecBuilder;
import io.fabric8.knative.eventing.v1.TriggerSpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.KnativeSupport;
import org.citrusframework.yaks.knative.actions.AbstractKnativeAction;

public class CreateTriggerAction
extends AbstractKnativeAction {
    private final String triggerName;
    private final String serviceName;
    private final String channelName;
    private final Map<String, String> filterOnAttributes;

    public CreateTriggerAction(Builder builder) {
        super("create-trigger", builder);
        this.triggerName = builder.triggerName;
        this.serviceName = builder.serviceName;
        this.channelName = builder.channelName;
        this.filterOnAttributes = builder.filterOnAttributes;
    }

    public void doExecute(TestContext context) {
        TriggerSpecBuilder triggerSpec = (TriggerSpecBuilder)new TriggerSpecBuilder().withBroker(this.brokerName(context));
        this.addServiceSubscriber(triggerSpec, context);
        this.addChannelSubscriber(triggerSpec, context);
        this.addFilterOnAttributes(triggerSpec, context);
        Trigger trigger = ((TriggerBuilder)((TriggerBuilder)((TriggerFluent.MetadataNested)((TriggerFluent.MetadataNested)((TriggerFluent.MetadataNested)((TriggerBuilder)new TriggerBuilder().withApiVersion(String.format("%s/%s", KnativeSupport.knativeEventingGroup(), KnativeSupport.knativeApiVersion()))).withNewMetadata().withNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.triggerName))).withLabels(KnativeSettings.getDefaultLabels())).endMetadata()).withSpec(triggerSpec.build())).build();
        ((NonNamespaceOperation)this.getKnativeClient().triggers().inNamespace(this.namespace(context))).createOrReplace((Object)trigger);
    }

    private void addFilterOnAttributes(TriggerSpecBuilder triggerSpec, TestContext context) {
        if (!this.filterOnAttributes.isEmpty()) {
            ((TriggerSpecFluent.FilterNested)triggerSpec.withNewFilter().withAttributes(context.resolveDynamicValuesInMap(this.filterOnAttributes))).endFilter();
        }
    }

    private void addChannelSubscriber(TriggerSpecBuilder triggerSpec, TestContext context) {
        if (this.channelName != null) {
            ((TriggerSpecFluent.SubscriberNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)triggerSpec.withNewSubscriber().withNewRef().withApiVersion(String.format("%s/%s", KnativeSupport.knativeMessagingGroup(), KnativeSupport.knativeApiVersion()))).withKind("InMemoryChannel")).withName(context.replaceDynamicContentInString(this.channelName))).endRef()).endSubscriber();
        }
    }

    private void addServiceSubscriber(TriggerSpecBuilder triggerSpec, TestContext context) {
        if (this.serviceName != null) {
            ((TriggerSpecFluent.SubscriberNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)triggerSpec.withNewSubscriber().withNewRef().withApiVersion("v1")).withKind("Service")).withName(context.replaceDynamicContentInString(this.serviceName))).endRef()).endSubscriber();
        }
    }

    public static class Builder
    extends AbstractKnativeAction.Builder<CreateTriggerAction, Builder> {
        private String triggerName;
        private String serviceName;
        private String channelName;
        private Map<String, String> filterOnAttributes = new HashMap<String, String>();

        public Builder name(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public Builder onService(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder onChannel(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public Builder filter(Map<String, String> filter) {
            this.filterOnAttributes.putAll(filter);
            return this;
        }

        public Builder filter(String attributeName, String value) {
            this.filterOnAttributes.put(attributeName, value);
            return this;
        }

        public CreateTriggerAction build() {
            return new CreateTriggerAction(this);
        }
    }
}

