/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.yaks.knative.actions.AbstractKnativeAction;
import org.citrusframework.yaks.knative.actions.DeleteKnativeResourceAction;
import org.citrusframework.yaks.knative.actions.KnativeAction;
import org.citrusframework.yaks.knative.actions.eventing.CreateBrokerAction;
import org.citrusframework.yaks.knative.actions.eventing.CreateTriggerAction;
import org.citrusframework.yaks.knative.actions.eventing.VerifyBrokerAction;
import org.citrusframework.yaks.knative.actions.messaging.CreateChannelAction;
import org.citrusframework.yaks.knative.actions.messaging.CreateSubscriptionAction;
import org.springframework.util.Assert;

public class KnativeActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<KnativeAction> {
    private KubernetesClient kubernetesClient;
    private KnativeClient knativeClient;
    private AbstractKnativeAction.Builder<? extends KnativeAction, ?> delegate;

    public static KnativeActionBuilder knative() {
        return new KnativeActionBuilder();
    }

    public KnativeActionBuilder client(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
        return this;
    }

    public KnativeActionBuilder client(KnativeClient knativeClient) {
        this.knativeClient = knativeClient;
        return this;
    }

    public ChannelActionBuilder channels() {
        return new ChannelActionBuilder();
    }

    public SubscriptionActionBuilder subscriptions() {
        return new SubscriptionActionBuilder();
    }

    public TriggerActionBuilder trigger() {
        return new TriggerActionBuilder();
    }

    public BrokerActionBuilder brokers() {
        return new BrokerActionBuilder();
    }

    public KnativeAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        if (this.kubernetesClient != null) {
            this.delegate.client(this.kubernetesClient);
        }
        if (this.knativeClient != null) {
            this.delegate.client(this.knativeClient);
        }
        return (KnativeAction)this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public class ChannelActionBuilder {
        public CreateChannelAction.Builder create(String channelName) {
            CreateChannelAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((CreateChannelAction.Builder)((Object)((CreateChannelAction.Builder)((Object)new CreateChannelAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).name(channelName);
            return builder;
        }

        public DeleteKnativeResourceAction.Builder delete(String channelName) {
            DeleteKnativeResourceAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((DeleteKnativeResourceAction.Builder)((Object)((DeleteKnativeResourceAction.Builder)((Object)new DeleteKnativeResourceAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).component("messaging").kind("channels").name(channelName);
            return builder;
        }
    }

    public class SubscriptionActionBuilder {
        public CreateSubscriptionAction.Builder create(String subscriptionName) {
            CreateSubscriptionAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((CreateSubscriptionAction.Builder)((Object)((CreateSubscriptionAction.Builder)((Object)new CreateSubscriptionAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).name(subscriptionName);
            return builder;
        }

        public DeleteKnativeResourceAction.Builder delete(String subscriptionName) {
            DeleteKnativeResourceAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((DeleteKnativeResourceAction.Builder)((Object)((DeleteKnativeResourceAction.Builder)((Object)new DeleteKnativeResourceAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).component("messaging").kind("subscriptions").name(subscriptionName);
            return builder;
        }
    }

    public class TriggerActionBuilder {
        public CreateTriggerAction.Builder create(String triggerName) {
            CreateTriggerAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((CreateTriggerAction.Builder)((Object)((CreateTriggerAction.Builder)((Object)new CreateTriggerAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).name(triggerName);
            return builder;
        }

        public DeleteKnativeResourceAction.Builder delete(String triggerName) {
            DeleteKnativeResourceAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((DeleteKnativeResourceAction.Builder)((Object)((DeleteKnativeResourceAction.Builder)((Object)new DeleteKnativeResourceAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).component("eventing").kind("triggers").name(triggerName);
            return builder;
        }
    }

    public class BrokerActionBuilder {
        public CreateBrokerAction.Builder create(String brokerName) {
            CreateBrokerAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((CreateBrokerAction.Builder)((Object)((CreateBrokerAction.Builder)((Object)new CreateBrokerAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).name(brokerName);
            return builder;
        }

        public DeleteKnativeResourceAction.Builder delete(String brokerName) {
            DeleteKnativeResourceAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((DeleteKnativeResourceAction.Builder)((Object)((DeleteKnativeResourceAction.Builder)((Object)new DeleteKnativeResourceAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).component("eventing").kind("brokers").name(brokerName);
            return builder;
        }

        public VerifyBrokerAction.Builder verify(String brokerName) {
            VerifyBrokerAction.Builder builder;
            KnativeActionBuilder.this.delegate = builder = ((VerifyBrokerAction.Builder)((Object)((VerifyBrokerAction.Builder)((Object)new VerifyBrokerAction.Builder().client(KnativeActionBuilder.this.kubernetesClient))).client(KnativeActionBuilder.this.knativeClient))).name(brokerName);
            return builder;
        }
    }
}

