/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative.actions;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.knative.KnativeSupport;
import org.citrusframework.yaks.knative.actions.AbstractKnativeAction;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class DeleteKnativeResourceAction
extends AbstractKnativeAction {
    private final String component;
    private final String kind;
    private final String resourceName;

    public DeleteKnativeResourceAction(Builder builder) {
        super("delete-" + builder.kind, builder);
        this.component = builder.component;
        this.kind = builder.kind;
        this.resourceName = builder.resourceName;
    }

    public void doExecute(TestContext context) {
        KubernetesSupport.deleteResource((KubernetesClient)this.getKubernetesClient(), (String)this.namespace(context), (ResourceDefinitionContext)KnativeSupport.knativeCRDContext(this.component, this.kind, KnativeSupport.knativeApiVersion()), (String)this.resourceName);
    }

    public static class Builder
    extends AbstractKnativeAction.Builder<DeleteKnativeResourceAction, Builder> {
        private String component = "eventing";
        private String kind;
        private String resourceName;

        public Builder component(String component) {
            this.component = component;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder name(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public DeleteKnativeResourceAction build() {
            return new DeleteKnativeResourceAction(this);
        }
    }
}

