/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import io.fabric8.knative.client.DefaultKnativeClient;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import org.citrusframework.Citrus;
import org.citrusframework.yaks.knative.KnativeSettings;

public final class KnativeSupport {
    private KnativeSupport() {
    }

    public static KnativeClient getKnativeClient(Citrus citrus) {
        if ((long)citrus.getCitrusContext().getReferenceResolver().resolveAll(KnativeClient.class).size() == 1L) {
            return (KnativeClient)citrus.getCitrusContext().getReferenceResolver().resolve(KnativeClient.class);
        }
        return new DefaultKnativeClient();
    }

    public static CustomResourceDefinitionContext knativeCRDContext(String knativeComponent, String kind, String version) {
        return new CustomResourceDefinitionContext.Builder().withName(String.format("%s.%s.knative.dev", kind, knativeComponent)).withGroup(String.format("%s.knative.dev", knativeComponent)).withVersion(version).withPlural(kind).withScope("Namespaced").build();
    }

    public static String knativeApiVersion() {
        return KnativeSettings.getApiVersion();
    }

    public static String knativeMessagingGroup() {
        return KnativeSettings.getKnativeMessagingGroup();
    }

    public static String knativeEventingGroup() {
        return KnativeSettings.getKnativeEventingGroup();
    }
}

