/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.knative.KnativeVariableNames;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;
import org.springframework.util.StringUtils;

public class KnativeSettings {
    private static final String KNATIVE_PROPERTY_PREFIX = "yaks.knative.";
    private static final String KNATIVE_ENV_PREFIX = "YAKS_KNATIVE_";
    private static final String EVENT_PRODUCER_TIMEOUT_PROPERTY = "yaks.knative.event.producer.timeout";
    private static final String EVENT_PRODUCER_TIMEOUT_ENV = "YAKS_KNATIVE_EVENT_PRODUCER_TIMEOUT";
    private static final String EVENT_PRODUCER_TIMEOUT_DEFAULT = "2000";
    private static final String EVENT_CONSUMER_TIMEOUT_PROPERTY = "yaks.knative.event.consumer.timeout";
    private static final String EVENT_CONSUMER_TIMEOUT_ENV = "YAKS_KNATIVE_EVENT_CONSUMER_TIMEOUT";
    private static final String EVENT_CONSUMER_TIMEOUT_DEFAULT = "2000";
    private static final String NAMESPACE_PROPERTY = "yaks.knative.namespace";
    private static final String NAMESPACE_ENV = "YAKS_KNATIVE_NAMESPACE";
    private static final String API_VERSION_PROPERTY = "yaks.knative.api.version";
    private static final String API_VERSION_ENV = "YAKS_KNATIVE_API_VERSION";
    private static final String API_VERSION_DEFAULT = "v1";
    private static final String BROKER_HOST_PROPERTY = "yaks.knative.broker.host";
    private static final String BROKER_HOST_ENV = "YAKS_KNATIVE_BROKER_HOST";
    private static final String BROKER_HOST_KUBERNETES_DEFAULT = String.format("broker-ingress.knative-eventing.%s", "svc.cluster.local");
    private static final String BROKER_HOST_OPENSHIFT_DEFAULT = String.format("${%s}-broker.%s.%s", KnativeVariableNames.BROKER_NAME.value(), KnativeSettings.getNamespace(), "svc.cluster.local");
    private static final String BROKER_NAME_PROPERTY = "yaks.knative.broker.name";
    private static final String BROKER_NAME_ENV = "YAKS_KNATIVE_BROKER_NAME";
    private static final String BROKER_NAME_DEFAULT = "default";
    private static final String BROKER_URL_PROPERTY = "yaks.knative.broker.url";
    private static final String BROKER_URL_ENV = "YAKS_KNATIVE_BROKER_URL";
    private static final String SERVICE_NAME_PROPERTY = "yaks.knative.service.name";
    private static final String SERVICE_NAME_ENV = "YAKS_KNATIVE_SERVICE_NAME";
    private static final String SERVICE_NAME_DEFAULT = "yaks-knative-service";
    private static final String SERVICE_PORT_PROPERTY = "yaks.knative.service.port";
    private static final String SERVICE_PORT_ENV = "YAKS_KNATIVE_SERVICE_PORT";
    private static final String AUTO_REMOVE_RESOURCES_PROPERTY = "yaks.knative.auto.remove.resources";
    private static final String AUTO_REMOVE_RESOURCES_ENV = "YAKS_KNATIVE_AUTO_REMOVE_RESOURCES";
    private static final String AUTO_REMOVE_RESOURCES_DEFAULT = "true";
    private static final String DEFAULT_LABELS_PROPERTY = "yaks.knative.default.labels";
    private static final String DEFAULT_LABELS_ENV = "YAKS_KNATIVE_DEFAULT_LABELS";

    private KnativeSettings() {
    }

    public static long getEventProducerTimeout() {
        return Long.parseLong(System.getProperty(EVENT_PRODUCER_TIMEOUT_PROPERTY, System.getenv(EVENT_PRODUCER_TIMEOUT_ENV) != null ? System.getenv(EVENT_PRODUCER_TIMEOUT_ENV) : "2000"));
    }

    public static long getEventConsumerTimeout() {
        return Long.parseLong(System.getProperty(EVENT_CONSUMER_TIMEOUT_PROPERTY, System.getenv(EVENT_CONSUMER_TIMEOUT_ENV) != null ? System.getenv(EVENT_CONSUMER_TIMEOUT_ENV) : "2000"));
    }

    public static String getNamespace() {
        return System.getProperty(NAMESPACE_PROPERTY, System.getenv(NAMESPACE_ENV) != null ? System.getenv(NAMESPACE_ENV) : YaksSettings.getDefaultNamespace());
    }

    public static String getApiVersion() {
        return System.getProperty(API_VERSION_PROPERTY, System.getenv(API_VERSION_ENV) != null ? System.getenv(API_VERSION_ENV) : API_VERSION_DEFAULT);
    }

    public static String getBrokerHost() {
        String brokerHostDefault = YaksSettings.isOpenshiftCluster() ? BROKER_HOST_OPENSHIFT_DEFAULT : (YaksSettings.isKubernetesCluster() ? BROKER_HOST_KUBERNETES_DEFAULT : "localhost");
        return System.getProperty(BROKER_HOST_PROPERTY, System.getenv(BROKER_HOST_ENV) != null ? System.getenv(BROKER_HOST_ENV) : brokerHostDefault);
    }

    public static String getBrokerName() {
        return System.getProperty(BROKER_NAME_PROPERTY, System.getenv(BROKER_NAME_ENV) != null ? System.getenv(BROKER_NAME_ENV) : BROKER_NAME_DEFAULT);
    }

    public static String getBrokerUrl() {
        String brokerUrlDefault = YaksSettings.isOpenshiftCluster() ? String.format("http://%s", KnativeSettings.getBrokerHost()) : (YaksSettings.isKubernetesCluster() ? String.format("http://%s/%s/${%s}", KnativeSettings.getBrokerHost(), KnativeSettings.getNamespace(), KnativeVariableNames.BROKER_NAME.value()) : String.format("http://%s", KnativeSettings.getBrokerHost()));
        return System.getProperty(BROKER_URL_PROPERTY, System.getenv(BROKER_URL_ENV) != null ? System.getenv(BROKER_URL_ENV) : brokerUrlDefault);
    }

    public static String getServiceName() {
        return System.getProperty(SERVICE_NAME_PROPERTY, System.getenv(SERVICE_NAME_ENV) != null ? System.getenv(SERVICE_NAME_ENV) : SERVICE_NAME_DEFAULT);
    }

    public static String getServicePort() {
        return Optional.ofNullable(System.getProperty(SERVICE_PORT_PROPERTY, System.getenv(SERVICE_PORT_ENV))).orElseGet(KubernetesSettings::getServicePort);
    }

    public static Map<String, String> getDefaultLabels() {
        String labelsConfig = System.getProperty(DEFAULT_LABELS_PROPERTY, System.getenv(DEFAULT_LABELS_ENV));
        if (labelsConfig == null) {
            return KubernetesSettings.getDefaultLabels();
        }
        return Stream.of(StringUtils.commaDelimitedListToStringArray((String)labelsConfig)).map(item -> StringUtils.delimitedListToStringArray((String)item, (String)"=")).filter(keyValue -> ((String[])keyValue).length == 2).collect(Collectors.toMap(item -> item[0], item -> item[1]));
    }

    public static boolean isAutoRemoveResources() {
        return Boolean.parseBoolean(System.getProperty(AUTO_REMOVE_RESOURCES_PROPERTY, System.getenv(AUTO_REMOVE_RESOURCES_ENV) != null ? System.getenv(AUTO_REMOVE_RESOURCES_ENV) : AUTO_REMOVE_RESOURCES_DEFAULT));
    }

    public static String getKnativeMessagingGroup() {
        return "messaging.knative.dev";
    }

    public static String getKnativeEventingGroup() {
        return "eventing.knative.dev";
    }
}

