/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.yaks.knative.KnativeSteps;
import org.citrusframework.yaks.knative.KnativeSupport;
import org.citrusframework.yaks.knative.actions.KnativeActionBuilder;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class KnativeMessagingSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    private KubernetesClient k8sClient;
    private KnativeClient knativeClient;

    @Before
    public void before(Scenario scenario) {
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        if (this.knativeClient == null) {
            this.knativeClient = KnativeSupport.getKnativeClient(this.citrus);
        }
    }

    @Given(value="^create Knative channel ([^\\s]+)$")
    public void createChannel(String channelName) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).channels().create(channelName));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).channels().delete(channelName)}));
        }
    }

    @Given(value="^delete Knative channel ([^\\s]+)$")
    public void deleteChannel(String channelName) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).channels().delete(channelName));
    }

    @Given(value="^subscribe service ([^\\s]+) to Knative channel ([^\\s]+)$")
    public void createSubscription(String serviceName, String channelName) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).subscriptions().create(serviceName + "-subscription").onChannel(channelName).service(serviceName));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).subscriptions().delete(serviceName + "-subscription")}));
        }
    }
}

