/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.knative;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.Citrus;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.CreateVariablesAction;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.container.RepeatOnErrorUntilTrue;
import org.citrusframework.yaks.knative.KnativeSettings;
import org.citrusframework.yaks.knative.KnativeSteps;
import org.citrusframework.yaks.knative.KnativeSupport;
import org.citrusframework.yaks.knative.KnativeVariableNames;
import org.citrusframework.yaks.knative.actions.KnativeActionBuilder;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class KnativeEventingSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    private KubernetesClient k8sClient;
    private KnativeClient knativeClient;
    private String brokerName = KnativeSettings.getBrokerName();

    @Before
    public void before(Scenario scenario) {
        this.runner.variable(KnativeVariableNames.BROKER_NAME.value(), (Object)this.brokerName);
        if (this.k8sClient == null) {
            this.k8sClient = KubernetesSupport.getKubernetesClient((Citrus)this.citrus);
        }
        if (this.knativeClient == null) {
            this.knativeClient = KnativeSupport.getKnativeClient(this.citrus);
        }
    }

    @Given(value="^Knative broker ([^\\s]+)$")
    public void useBroker(String brokerName) {
        this.setBrokerName(brokerName);
    }

    @Given(value="^create Knative broker ([^\\s]+)$")
    public void createBroker(String brokerName) {
        this.setBrokerName(brokerName);
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).brokers().create(brokerName));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).brokers().delete(brokerName)}));
        }
    }

    @Given(value="^delete Knative broker ([^\\s]+)$")
    public void deleteBroker(String brokerName) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).brokers().delete(brokerName));
    }

    @Given(value="^Knative broker ([^\\s]+) is running$")
    public void verifyBrokerIsRunning(String brokerName) {
        this.runner.then((TestActionBuilder)RepeatOnErrorUntilTrue.Builder.repeatOnError().autoSleep(500L).until((i, context) -> i == 10).actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).brokers().verify(brokerName)}));
    }

    @Given(value="^create Knative trigger ([^\\s]+) on service ([^\\s]+)$")
    public void createTriggerOnService(String triggerName, String serviceName) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().create(triggerName).onService(serviceName));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().delete(triggerName)}));
        }
    }

    @Given(value="^create Knative trigger ([^\\s]+) on service ([^\\s]+) with filter on attributes$")
    public void createTriggerOnServiceFiltered(String triggerName, String serviceName, DataTable filterAttributes) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().create(triggerName).onService(serviceName).filter(filterAttributes.asMap(String.class, String.class)));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().delete(triggerName)}));
        }
    }

    @Given(value="^create Knative trigger ([^\\s]+) on channel ([^\\s]+)$")
    public void createTriggerOnChannel(String triggerName, String channelName) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().create(triggerName).onChannel(channelName));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().delete(triggerName)}));
        }
    }

    @Given(value="^create Knative trigger ([^\\s]+) on channel ([^\\s]+) with filter on attributes$")
    public void createTriggerFiltered(String triggerName, String channelName, DataTable filterAttributes) {
        this.runner.given((TestActionBuilder)KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().create(triggerName).onChannel(channelName).filter(filterAttributes.asMap(String.class, String.class)));
        if (KnativeSteps.autoRemoveResources) {
            this.runner.then((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestActionBuilder[]{KnativeActionBuilder.knative().client(this.k8sClient).client(this.knativeClient).trigger().delete(triggerName)}));
        }
    }

    private void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
        this.runner.run((TestActionBuilder)CreateVariablesAction.Builder.createVariable((String)KnativeVariableNames.BROKER_NAME.value(), (String)brokerName));
    }
}

