/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.MessageType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public interface HttpSteps {
    default public String getMessageType(String contentType) {
        List<MediaType> binaryMediaTypes = Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PDF, MediaType.IMAGE_GIF, MediaType.IMAGE_JPEG, MediaType.IMAGE_PNG, MediaType.valueOf((String)"application/zip"));
        if (contentType.equals("application/json") || contentType.equals("application/json;charset=UTF-8")) {
            return MessageType.JSON.name();
        }
        if (contentType.equals("application/xml")) {
            return MessageType.XML.name();
        }
        if (contentType.equals("application/xhtml+xml")) {
            return MessageType.XHTML.name();
        }
        if (contentType.equals("text/plain") || contentType.equals("text/html")) {
            return MessageType.PLAINTEXT.name();
        }
        if (binaryMediaTypes.stream().anyMatch(mediaType -> contentType.equals(mediaType.getType()))) {
            return MessageType.BINARY.name();
        }
        return CitrusSettings.DEFAULT_MESSAGE_TYPE;
    }

    default public HttpMessage createRequest(String body, Map<String, String> headers, Map<String, String> params, String method, String path) {
        HttpMessage request = new HttpMessage();
        request.method(HttpMethod.valueOf((String)method));
        if (StringUtils.hasText((String)path)) {
            request.path(path);
        }
        if (StringUtils.hasText((String)body)) {
            request.setPayload((Object)body);
        }
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            request.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            request.queryParam(paramEntry.getKey(), paramEntry.getValue());
        }
        return request;
    }

    default public HttpMessage createResponse(String body, Map<String, String> headers, Integer status) {
        HttpMessage response = new HttpMessage();
        response.status(HttpStatus.valueOf((int)status));
        if (StringUtils.hasText((String)body)) {
            response.setPayload((Object)body);
        }
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            response.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        return response;
    }
}

