/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http;

public class HttpSettings {
    private static final String HTTP_PROPERTY_PREFIX = "yaks.http.";
    private static final String HTTP_ENV_PREFIX = "YAKS_HTTP_";
    private static final String TIMEOUT_PROPERTY = "yaks.http..timeout";
    private static final String TIMEOUT_ENV = "YAKS_HTTP__TIMEOUT";
    private static final String TIMEOUT_DEFAULT = "2000";
    private static final String FORK_MODE_PROPERTY = "yaks.http..fork.mode";
    private static final String FORK_MODE_ENV = "YAKS_HTTP__FORK_MODE";
    private static final String FORK_MODE_DEFAULT = "false";
    private static final String SERVER_NAME_PROPERTY = "yaks.http.server.name";
    private static final String SERVER_NAME_ENV = "YAKS_HTTP_SERVER_NAME";
    private static final String SERVER_NAME_DEFAULT = "yaks-http-server";
    private static final String SERVER_PORT_PROPERTY = "yaks.http.server.port";
    private static final String SERVER_PORT_ENV = "YAKS_HTTP_SERVER_PORT";
    private static final String SERVER_PORT_DEFAULT = "8080";
    private static final String SECURE_PORT_PROPERTY = "yaks.http.secure.port";
    private static final String SECURE_PORT_ENV = "YAKS_HTTP_SECURE_PORT";
    private static final String SECURE_PORT_DEFAULT = "8443";
    private static final String SECURE_KEYSTORE_PATH_PROPERTY = "yaks.http.secure.keystore.path";
    private static final String SECURE_KEYSTORE_PATH_ENV = "YAKS_HTTP_SECURE_KEYSTORE_PATH";
    static final String SECURE_KEYSTORE_PATH_DEFAULT = "classpath:keystore/http-server.jks";
    private static final String SECURE_KEYSTORE_PASSWORD_PROPERTY = "yaks.http.secure.keystore.password";
    private static final String SECURE_KEYSTORE_PASSWORD_ENV = "YAKS_HTTP_SECURE_KEYSTORE_PASSWORD";
    private static final String SECURE_KEYSTORE_PASSWORD_DEFAULT = "secret";

    private HttpSettings() {
    }

    public static long getTimeout() {
        return Long.parseLong(System.getProperty(TIMEOUT_PROPERTY, System.getenv(TIMEOUT_ENV) != null ? System.getenv(TIMEOUT_ENV) : TIMEOUT_DEFAULT));
    }

    public static boolean getForkMode() {
        return Boolean.parseBoolean(System.getProperty(FORK_MODE_PROPERTY, System.getenv(FORK_MODE_ENV) != null ? System.getenv(FORK_MODE_ENV) : FORK_MODE_DEFAULT));
    }

    public static String getServerName() {
        return System.getProperty(SERVER_NAME_PROPERTY, System.getenv(SERVER_NAME_ENV) != null ? System.getenv(SERVER_NAME_ENV) : SERVER_NAME_DEFAULT);
    }

    public static int getServerPort() {
        return Integer.parseInt(System.getProperty(SERVER_PORT_PROPERTY, System.getenv(SERVER_PORT_ENV) != null ? System.getenv(SERVER_PORT_ENV) : SERVER_PORT_DEFAULT));
    }

    public static int getSecurePort() {
        return Integer.parseInt(System.getProperty(SECURE_PORT_PROPERTY, System.getenv(SECURE_PORT_ENV) != null ? System.getenv(SECURE_PORT_ENV) : SECURE_PORT_DEFAULT));
    }

    public static String getSslKeyStorePath() {
        return System.getProperty(SECURE_KEYSTORE_PATH_PROPERTY, System.getenv(SECURE_KEYSTORE_PATH_ENV) != null ? System.getenv(SECURE_KEYSTORE_PATH_ENV) : SECURE_KEYSTORE_PATH_DEFAULT);
    }

    public static String getSslKeyStorePassword() {
        return System.getProperty(SECURE_KEYSTORE_PASSWORD_PROPERTY, System.getenv(SECURE_KEYSTORE_PASSWORD_ENV) != null ? System.getenv(SECURE_KEYSTORE_PASSWORD_ENV) : SECURE_KEYSTORE_PASSWORD_DEFAULT);
    }
}

