/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusSettings;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.Wait;
import org.citrusframework.container.WaitHttpConditionBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpActionBuilder;
import org.citrusframework.http.actions.HttpClientActionBuilder;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.actions.HttpClientResponseActionBuilder;
import org.citrusframework.http.client.BasicAuthClientHttpRequestFactory;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.client.HttpClientBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.PathExpressionValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.citrusframework.yaks.http.HttpSettings;
import org.citrusframework.yaks.http.HttpSteps;
import org.citrusframework.yaks.util.ResourceUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpClientSteps
implements HttpSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestContext context;
    private HttpClient httpClient;
    private String requestUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private Map<String, String> requestParams = new HashMap<String, String>();
    private boolean headerNameIgnoreCase = HttpSettings.isHeaderNameIgnoreCase();
    private Map<String, Object> bodyValidationExpressions = new HashMap<String, Object>();
    private String requestMessageType;
    private String responseMessageType;
    private String requestBody;
    private String responseBody;
    private DataDictionary<?> outboundDictionary;
    private DataDictionary<?> inboundDictionary;
    private long timeout;
    private boolean forkMode = HttpSettings.getForkMode();
    private String authMethod = HttpSettings.getClientAuthMethod();
    private String authUser = HttpSettings.getClientAuthUser();
    private String authPassword = HttpSettings.getClientAuthPassword();
    private boolean useSslKeyStore = HttpSettings.isUseSslKeyStore();
    private String sslKeyStorePath = HttpSettings.getClientKeyStorePath();
    private String sslKeyStorePassword = HttpSettings.getClientKeyStorePassword();
    private boolean useSslTrustStore = HttpSettings.isUseSslTrustStore();
    private String sslTrustStorePath = HttpSettings.getTrustStorePath();
    private String sslTrustStorePassword = HttpSettings.getTrustStorePassword();

    @Before
    public void before(Scenario scenario) {
        if (this.httpClient == null) {
            this.httpClient = (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(HttpClient.class).size() == 1L ? (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(HttpClient.class) : (HttpClient)new HttpClientBuilder().timeout(HttpSettings.getTimeout()).build();
        }
        this.timeout = this.httpClient.getEndpointConfiguration().getTimeout();
        this.requestHeaders = new HashMap<String, String>();
        this.responseHeaders = new HashMap<String, String>();
        this.requestParams = new HashMap<String, String>();
        this.requestMessageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
        this.responseMessageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
        this.requestBody = null;
        this.responseBody = null;
        this.bodyValidationExpressions = new HashMap<String, Object>();
        this.outboundDictionary = null;
        this.inboundDictionary = null;
    }

    @Given(value="^HTTP client \"([^\"\\s]+)\"$")
    public void setClient(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find http client for id: " + id);
        }
        this.httpClient = (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, HttpClient.class);
    }

    @Given(value="^(?:URL|url): ([^\\s]+)$")
    public void setUrl(String url) {
        String resolvedUrl = this.context.replaceDynamicContentInString(url);
        if (resolvedUrl.startsWith("https")) {
            this.httpClient.getEndpointConfiguration().setRequestFactory((ClientHttpRequestFactory)this.sslRequestFactory());
        }
        this.requestUrl = resolvedUrl;
    }

    @Given(value="^HTTP client (enable|disable) SSL truststore")
    public void setSecureTrustStore(String mode) {
        this.useSslTrustStore = "enable".equals(mode);
    }

    @Given(value="^HTTP client SSL truststore path ([^\\s]+)$")
    public void setSslTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = sslTrustStorePath;
        this.useSslTrustStore = true;
    }

    @Given(value="^HTTP client SSL truststore password ([^\\s]+)$")
    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    @Given(value="^HTTP client (enable|disable) SSL keystore$")
    public void setSecureKeyStore(String mode) {
        this.useSslKeyStore = "enable".equals(mode);
    }

    @Given(value="^HTTP client SSL keystore path ([^\\s]+)$")
    public void setSslKeyStorePath(String sslKeyStorePath) {
        this.sslKeyStorePath = sslKeyStorePath;
        this.useSslKeyStore = true;
    }

    @Given(value="^HTTP client SSL keystore password ([^\\s]+)$")
    public void setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    @Given(value="^HTTP client (enable|disable) basic auth$")
    public void setBasicAuth(String mode) {
        this.authMethod = "enable".equals(mode) ? "basic" : "none";
    }

    @Given(value="^HTTP client auth method (basic|digest|ntlm)$")
    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @Given(value="^HTTP client auth user ([^\\s]+)$")
    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    @Given(value="^HTTP client auth password ([^\\s]+)$")
    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    @Given(value="^HTTP request timeout is (\\d+)(?: ms| milliseconds)$")
    public void configureTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Given(value="^HTTP request fork mode is (enabled|disabled)$")
    public void configureForkMode(String mode) {
        this.forkMode = "enabled".equals(mode);
    }

    @Given(value="^HTTP header name ignore case is (enabled|disabled)$")
    public void configureHeaderNameIgnoreCase(String mode) {
        this.headerNameIgnoreCase = "enabled".equals(mode);
    }

    @Given(value="^(?:URL|url) is healthy$")
    public void healthCheck() {
        this.waitForHttpUrl(this.requestUrl);
    }

    @Given(value="^(?:URL|url|path) ([^\\s]+) is healthy$")
    public void healthCheck(String urlOrPath) {
        this.waitForHttpUrl(this.getRequestUrl(urlOrPath, this.context));
    }

    @Given(value="^wait for (?:URL|url|path) ([^\\s]+)$")
    public void waitForHttpUrl(String urlOrPath) {
        this.waitForHttpStatus(this.getRequestUrl(urlOrPath, this.context), 200);
    }

    @Given(value="^wait for (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) on (?:URL|url|path) ([^\\s]+)$")
    public void waitForHttpUrlUsingMethod(String method, String urlOrPath) {
        this.waitForHttpStatusUsingMethod(method, this.getRequestUrl(urlOrPath, this.context), 200);
    }

    @Given(value="^wait for (?:URL|url|path) ([^\\s]+) to return (\\d+)(?: [^\\s]+)?$")
    public void waitForHttpStatus(String urlOrPath, Integer statusCode) {
        this.runner.given((TestActionBuilder)((WaitHttpConditionBuilder)((WaitHttpConditionBuilder)Wait.Builder.waitFor().http().milliseconds(this.timeout)).interval(Long.valueOf(this.timeout / 10L))).status(statusCode.intValue()).url(this.getRequestUrl(urlOrPath, this.context)));
    }

    @Given(value="^wait for (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) on (?:URL|url|path) ([^\\s]+) to return (\\d+)(?: [^\\s]+)?$")
    public void waitForHttpStatusUsingMethod(String method, String urlOrPath, Integer statusCode) {
        this.runner.given((TestActionBuilder)((WaitHttpConditionBuilder)((WaitHttpConditionBuilder)Wait.Builder.waitFor().http().milliseconds(this.timeout)).method(method).interval(Long.valueOf(this.timeout / 10L))).status(statusCode.intValue()).url(this.getRequestUrl(urlOrPath, this.context)));
    }

    @Then(value="^(?:expect|verify) HTTP response header ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addResponseHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.responseMessageType = this.getMessageType(value);
        }
        this.responseHeaders.put(name, value);
    }

    @Then(value="^(?:expect|verify) HTTP response headers$")
    public void addResponseHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, String.class);
        headerPairs.forEach(this::addResponseHeader);
    }

    @Given(value="^HTTP request header ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addRequestHeader(String name, String value) {
        if (name.equals("Content-Type")) {
            this.requestMessageType = this.getMessageType(this.context.replaceDynamicContentInString(value));
        }
        this.requestHeaders.put(name, this.context.replaceDynamicContentInString(value));
    }

    @Given(value="^HTTP request query parameter ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addRequestQueryParam(String name, String value) {
        this.requestParams.put(name, value);
    }

    @Given(value="^HTTP request headers$")
    public void addRequestHeaders(DataTable headers) {
        Map headerPairs = headers.asMap(String.class, String.class);
        headerPairs.forEach(this::addRequestHeader);
    }

    @Then(value="^(?:expect|verify) HTTP response expression: ([^\\s]+)(?:=| is )\"(.+)\"$")
    public void addBodyValidationExpression(String name, String value) {
        this.bodyValidationExpressions.put(name, value);
    }

    @Then(value="^(?:expect|verify) HTTP response expressions$")
    public void addBodyValidationExpressions(DataTable validationExpressions) {
        Map expressions = validationExpressions.asMap(String.class, String.class);
        expressions.forEach(this::addBodyValidationExpression);
    }

    @Given(value="^HTTP request body$")
    public void setRequestBodyMultiline(String body) {
        this.setRequestBody(body);
    }

    @Given(value="^load HTTP request body ([^\\s]+)$")
    public void loadRequestBody(String file) {
        try {
            this.setRequestBody(FileUtils.readToString((Resource)ResourceUtils.resolve((String)file, (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Given(value="^HTTP request body: (.+)$")
    public void setRequestBody(String body) {
        this.requestBody = body;
    }

    @Then(value="^(?:expect|verify) HTTP response body$")
    public void setResponseBodyMultiline(String body) {
        this.setResponseBody(body);
    }

    @Given(value="^(?:expect|verify) HTTP response body loaded from ([^\\s]+)$")
    public void loadResponseBody(String file) {
        try {
            this.setResponseBody(FileUtils.readToString((Resource)ResourceUtils.resolve((String)file, (TestContext)this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Then(value="^(?:expect|verify) HTTP response body: (.+)$")
    public void setResponseBody(String body) {
        this.responseBody = body;
    }

    @When(value="^send HTTP request$")
    public void sendClientRequestFull(String requestData) {
        this.sendClientRequest(HttpMessage.fromRequestData((String)requestData));
    }

    @Then(value="^receive HTTP response$")
    public void receiveClientResponseFull(String responseData) {
        this.receiveClientResponse(HttpMessage.fromResponseData((String)responseData));
    }

    @When(value="^send (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE)$")
    public void sendClientRequestMultilineBody(String method) {
        this.sendClientRequest(method, null);
    }

    @When(value="^send (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) ([^\"\\s]+)$")
    public void sendClientRequest(String method, String path) {
        this.sendClientRequest(this.createRequest(this.requestBody, this.requestHeaders, this.requestParams, method, path, this.context));
        this.requestBody = null;
        this.requestHeaders.clear();
        this.requestParams.clear();
    }

    @Then(value="^receive HTTP (\\d+)(?: [^\\s]+)?$")
    public void receiveClientResponse(Integer status) {
        this.receiveClientResponse(this.createResponse(this.responseBody, this.responseHeaders, status, this.context));
        this.responseBody = null;
        this.responseHeaders.clear();
    }

    private void sendClientRequest(HttpMessage request) {
        HttpClientActionBuilder.HttpClientSendActionBuilder sendBuilder = HttpActionBuilder.http().client(this.httpClient).send();
        HttpClientRequestActionBuilder.HttpMessageBuilderSupport requestBuilder = request.getRequestMethod() == null || request.getRequestMethod().equals((Object)RequestMethod.GET) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.post().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.GET) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.get().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.PUT) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.put().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.DELETE) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.delete().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.HEAD) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.head().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.TRACE) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.trace().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.PATCH) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.patch().message((Message)request) : (request.getRequestMethod().equals((Object)RequestMethod.OPTIONS) ? (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.options().message((Message)request) : (HttpClientRequestActionBuilder.HttpMessageBuilderSupport)sendBuilder.post().message((Message)request))))))));
        requestBuilder.fork(this.forkMode);
        if (StringUtils.hasText((String)this.requestUrl)) {
            requestBuilder.uri(this.requestUrl);
        }
        requestBuilder.type(this.requestMessageType);
        if (this.outboundDictionary != null) {
            requestBuilder.dictionary(this.outboundDictionary);
        }
        if ("basic".equals(this.authMethod)) {
            try {
                this.httpClient.getEndpointConfiguration().setRequestFactory((ClientHttpRequestFactory)this.basicAuthRequestFactory());
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Failed to configure basic auth on server", (Throwable)e);
            }
        } else {
            TestActionBuilder.logger.warn("Unsupported auth method for Http server: '%s'".formatted(this.authMethod));
        }
        this.runner.run((TestActionBuilder)requestBuilder);
    }

    private void receiveClientResponse(HttpMessage response) {
        HttpClientResponseActionBuilder.HttpMessageBuilderSupport responseBuilder = (HttpClientResponseActionBuilder.HttpMessageBuilderSupport)((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)HttpActionBuilder.http().client(this.httpClient).receive().response((HttpStatusCode)HttpStatus.resolve((int)response.getStatusCode().value())).message((Message)response)).headerNameIgnoreCase(this.headerNameIgnoreCase);
        responseBuilder.validate((ValidationContext.Builder)PathExpressionValidationContext.Builder.pathExpression().expressions(this.bodyValidationExpressions));
        this.bodyValidationExpressions.clear();
        responseBuilder.timeout(this.timeout);
        responseBuilder.type(this.responseMessageType);
        if (this.inboundDictionary != null) {
            responseBuilder.dictionary(this.inboundDictionary);
        }
        this.runner.run((TestActionBuilder)responseBuilder);
    }

    private HttpComponentsClientHttpRequestFactory sslRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.sslClient());
    }

    private org.apache.hc.client5.http.classic.HttpClient sslClient() {
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (this.useSslTrustStore && StringUtils.hasText((String)this.sslTrustStorePath)) {
                sslContextBuilder.loadTrustMaterial(ResourceUtils.resolve((String)this.sslTrustStorePath, (TestContext)this.context).getURL(), this.sslTrustStorePassword.toCharArray());
            } else {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            }
            if (this.useSslKeyStore && StringUtils.hasText((String)this.sslKeyStorePath)) {
                sslContextBuilder.loadKeyMaterial(ResourceUtils.resolve((String)this.sslKeyStorePath, (TestContext)this.context).getURL(), this.sslKeyStorePassword.toCharArray(), this.sslKeyStorePassword.toCharArray());
            }
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new CitrusRuntimeException("Failed to create http client for ssl connection", (Throwable)e);
        }
    }

    private String getRequestUrl(String urlOrPath, TestContext context) {
        String url;
        String resolvedUrlOrPath = context.replaceDynamicContentInString(urlOrPath);
        if (StringUtils.hasText((String)resolvedUrlOrPath) && resolvedUrlOrPath.startsWith("http")) {
            return resolvedUrlOrPath;
        }
        if (StringUtils.hasText((String)this.requestUrl)) {
            url = this.requestUrl;
        } else if (StringUtils.hasText((String)this.httpClient.getEndpointConfiguration().getRequestUrl())) {
            url = this.httpClient.getEndpointConfiguration().getRequestUrl();
        } else {
            throw new CitrusRuntimeException("Must provide a base request URL first when using relative resource path: " + urlOrPath);
        }
        if (!StringUtils.hasText((String)resolvedUrlOrPath) || resolvedUrlOrPath.equals("/")) {
            return url;
        }
        return (String)(url.endsWith("/") ? url : url + "/") + (resolvedUrlOrPath.startsWith("/") ? resolvedUrlOrPath.substring(1) : resolvedUrlOrPath);
    }

    private HttpComponentsClientHttpRequestFactory basicAuthRequestFactory() {
        try {
            URL url;
            BasicAuthClientHttpRequestFactory requestFactory = new BasicAuthClientHttpRequestFactory();
            if (StringUtils.hasText((String)this.requestUrl)) {
                url = new URL(this.requestUrl);
            } else if (StringUtils.hasText((String)this.httpClient.getEndpointConfiguration().getRequestUrl())) {
                url = new URL(this.httpClient.getEndpointConfiguration().getRequestUrl());
            } else {
                throw new CitrusRuntimeException("Must provide a base request URL when configuring basic auth on Http client");
            }
            AuthScope authScope = new AuthScope(url.getProtocol(), url.getHost(), url.getPort(), "", "basic");
            requestFactory.setAuthScope(authScope);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.authUser, this.authPassword.toCharArray());
            requestFactory.setCredentials((Credentials)credentials);
            requestFactory.initialize();
            return requestFactory.getObject();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to configure basic auth on Http client", (Throwable)e);
        }
    }

    public void setInboundDictionary(DataDictionary<?> inboundDictionary) {
        this.inboundDictionary = inboundDictionary;
    }

    public void setOutboundDictionary(DataDictionary<?> outboundDictionary) {
        this.outboundDictionary = outboundDictionary;
    }
}

