/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.http;

public class HttpSettings {
    private static final String HTTP_PROPERTY_PREFIX = "yaks.http.";
    private static final String HTTP_ENV_PREFIX = "YAKS_HTTP_";
    private static final String TIMEOUT_PROPERTY = "yaks.http.timeout";
    private static final String TIMEOUT_ENV = "YAKS_HTTP_TIMEOUT";
    private static final String TIMEOUT_DEFAULT = "2000";
    private static final String SERVER_AUTH_PATH_PROPERTY = "yaks.http.server.auth.path";
    private static final String SERVER_AUTH_PATH_ENV = "YAKS_HTTP_SERVER_AUTH_PATH";
    private static final String SERVER_AUTH_PATH_DEFAULT = "/secure/*";
    private static final String SERVER_AUTH_USER_ROLES_PROPERTY = "yaks.http.server.auth.user.roles";
    private static final String SERVER_AUTH_USER_ROLES_ENV = "YAKS_HTTP_SERVER_AUTH_USER_ROLES";
    private static final String SERVER_AUTH_USER_ROLES_DEFAULT = "citrus";
    private static final String AUTH_METHOD_PROPERTY = "yaks.http.auth.method";
    private static final String AUTH_METHOD_ENV = "YAKS_HTTP_AUTH_METHOD";
    private static final String AUTH_METHOD_DEFAULT = "none";
    private static final String SERVER_AUTH_METHOD_PROPERTY = "yaks.http.server.auth.method";
    private static final String SERVER_AUTH_METHOD_ENV = "YAKS_HTTP_SERVER_AUTH_METHOD";
    private static final String CLIENT_AUTH_METHOD_PROPERTY = "yaks.http.client.auth.method";
    private static final String CLIENT_AUTH_METHOD_ENV = "YAKS_HTTP_CLIENT_AUTH_METHOD";
    private static final String AUTH_USER_PROPERTY = "yaks.http.auth.user";
    private static final String AUTH_USER_ENV = "YAKS_HTTP_AUTH_USER";
    private static final String AUTH_USER_DEFAULT = "citrus";
    private static final String SERVER_AUTH_USER_PROPERTY = "yaks.http.server.auth.user";
    private static final String SERVER_AUTH_USER_ENV = "YAKS_HTTP_SERVER_AUTH_USER";
    private static final String CLIENT_AUTH_USER_PROPERTY = "yaks.http.client.auth.user";
    private static final String CLIENT_AUTH_USER_ENV = "YAKS_HTTP_CLIENT_AUTH_USER";
    private static final String AUTH_PASSWORD_PROPERTY = "yaks.http.auth.password";
    private static final String AUTH_PASSWORD_ENV = "YAKS_HTTP_AUTH_PASSWORD";
    private static final String AUTH_PASSWORD_DEFAULT = "secr3t";
    private static final String SERVER_AUTH_PASSWORD_PROPERTY = "yaks.http.server.auth.password";
    private static final String SERVER_AUTH_PASSWORD_ENV = "YAKS_HTTP_SERVER_AUTH_PASSWORD";
    private static final String CLIENT_AUTH_PASSWORD_PROPERTY = "yaks.http.client.auth.password";
    private static final String CLIENT_AUTH_PASSWORD_ENV = "YAKS_HTTP_CLIENT_AUTH_PASSWORD";
    private static final String FORK_MODE_PROPERTY = "yaks.http.fork.mode";
    private static final String FORK_MODE_ENV = "YAKS_HTTP_FORK_MODE";
    private static final String FORK_MODE_DEFAULT = "false";
    private static final String SERVER_NAME_PROPERTY = "yaks.http.server.name";
    private static final String SERVER_NAME_ENV = "YAKS_HTTP_SERVER_NAME";
    private static final String SERVER_NAME_DEFAULT = "yaks-http-server";
    private static final String SERVER_PORT_PROPERTY = "yaks.http.server.port";
    private static final String SERVER_PORT_ENV = "YAKS_HTTP_SERVER_PORT";
    private static final String SERVER_PORT_DEFAULT = "8080";
    private static final String SECURE_PORT_PROPERTY = "yaks.http.secure.port";
    private static final String SECURE_PORT_ENV = "YAKS_HTTP_SECURE_PORT";
    private static final String SECURE_PORT_DEFAULT = "8443";
    private static final String SECURE_KEYSTORE_PATH_PROPERTY = "yaks.http.secure.keystore.path";
    private static final String SECURE_KEYSTORE_PATH_ENV = "YAKS_HTTP_SECURE_KEYSTORE_PATH";
    static final String SECURE_KEYSTORE_PATH_DEFAULT = "classpath:keystore/http-server.jks";
    private static final String SECURE_KEYSTORE_PASSWORD_PROPERTY = "yaks.http.secure.keystore.password";
    private static final String SECURE_KEYSTORE_PASSWORD_ENV = "YAKS_HTTP_SECURE_KEYSTORE_PASSWORD";
    private static final String SECURE_KEYSTORE_PASSWORD_DEFAULT = "secret";
    private static final String HEADER_NAME_IGNORE_CASE_PROPERTY = "yaks.http.header.name.ignore.case";
    private static final String HEADER_NAME_IGNORE_CASE_ENV = "YAKS_HTTP_HEADER_NAME_IGNORE_CASE";
    private static final String HEADER_NAME_IGNORE_CASE_DEFAULT = "false";

    private HttpSettings() {
    }

    public static long getTimeout() {
        return Long.parseLong(System.getProperty(TIMEOUT_PROPERTY, System.getenv(TIMEOUT_ENV) != null ? System.getenv(TIMEOUT_ENV) : TIMEOUT_DEFAULT));
    }

    public static boolean getForkMode() {
        return Boolean.parseBoolean(System.getProperty(FORK_MODE_PROPERTY, System.getenv(FORK_MODE_ENV) != null ? System.getenv(FORK_MODE_ENV) : "false"));
    }

    public static String getServerName() {
        return System.getProperty(SERVER_NAME_PROPERTY, System.getenv(SERVER_NAME_ENV) != null ? System.getenv(SERVER_NAME_ENV) : SERVER_NAME_DEFAULT);
    }

    public static int getServerPort() {
        return Integer.parseInt(System.getProperty(SERVER_PORT_PROPERTY, System.getenv(SERVER_PORT_ENV) != null ? System.getenv(SERVER_PORT_ENV) : SERVER_PORT_DEFAULT));
    }

    public static int getSecurePort() {
        return Integer.parseInt(System.getProperty(SECURE_PORT_PROPERTY, System.getenv(SECURE_PORT_ENV) != null ? System.getenv(SECURE_PORT_ENV) : SECURE_PORT_DEFAULT));
    }

    public static String getSslKeyStorePath() {
        return System.getProperty(SECURE_KEYSTORE_PATH_PROPERTY, System.getenv(SECURE_KEYSTORE_PATH_ENV) != null ? System.getenv(SECURE_KEYSTORE_PATH_ENV) : SECURE_KEYSTORE_PATH_DEFAULT);
    }

    public static String getSslKeyStorePassword() {
        return System.getProperty(SECURE_KEYSTORE_PASSWORD_PROPERTY, System.getenv(SECURE_KEYSTORE_PASSWORD_ENV) != null ? System.getenv(SECURE_KEYSTORE_PASSWORD_ENV) : SECURE_KEYSTORE_PASSWORD_DEFAULT);
    }

    public static boolean isHeaderNameIgnoreCase() {
        return Boolean.parseBoolean(System.getProperty(HEADER_NAME_IGNORE_CASE_PROPERTY, System.getenv(HEADER_NAME_IGNORE_CASE_ENV) != null ? System.getenv(HEADER_NAME_IGNORE_CASE_ENV) : "false"));
    }

    public static String getServerAuthPath() {
        return System.getProperty(SERVER_AUTH_PATH_PROPERTY, System.getenv(SERVER_AUTH_PATH_ENV) != null ? System.getenv(SERVER_AUTH_PATH_ENV) : SERVER_AUTH_PATH_DEFAULT);
    }

    public static String[] getServerAuthUserRoles() {
        return System.getProperty(SERVER_AUTH_USER_ROLES_PROPERTY, System.getenv(SERVER_AUTH_USER_ROLES_ENV) != null ? System.getenv(SERVER_AUTH_USER_ROLES_ENV) : "citrus").split(",");
    }

    public static String getAuthMethod() {
        return System.getProperty(AUTH_METHOD_PROPERTY, System.getenv(AUTH_METHOD_ENV) != null ? System.getenv(AUTH_METHOD_ENV) : AUTH_METHOD_DEFAULT);
    }

    public static String getClientAuthMethod() {
        return System.getProperty(CLIENT_AUTH_METHOD_PROPERTY, System.getenv(CLIENT_AUTH_METHOD_ENV) != null ? System.getenv(CLIENT_AUTH_METHOD_ENV) : HttpSettings.getAuthMethod());
    }

    public static String getServerAuthMethod() {
        return System.getProperty(SERVER_AUTH_METHOD_PROPERTY, System.getenv(SERVER_AUTH_METHOD_ENV) != null ? System.getenv(SERVER_AUTH_METHOD_ENV) : HttpSettings.getAuthMethod());
    }

    public static String getAuthUser() {
        return System.getProperty(AUTH_USER_PROPERTY, System.getenv(AUTH_USER_ENV) != null ? System.getenv(AUTH_USER_ENV) : "citrus");
    }

    public static String getClientAuthUser() {
        return System.getProperty(CLIENT_AUTH_USER_PROPERTY, System.getenv(CLIENT_AUTH_USER_ENV) != null ? System.getenv(CLIENT_AUTH_USER_ENV) : HttpSettings.getAuthUser());
    }

    public static String getServerAuthUser() {
        return System.getProperty(SERVER_AUTH_USER_PROPERTY, System.getenv(SERVER_AUTH_USER_ENV) != null ? System.getenv(SERVER_AUTH_USER_ENV) : HttpSettings.getAuthUser());
    }

    public static String getAuthPassword() {
        return System.getProperty(AUTH_PASSWORD_PROPERTY, System.getenv(AUTH_PASSWORD_ENV) != null ? System.getenv(AUTH_PASSWORD_ENV) : AUTH_PASSWORD_DEFAULT);
    }

    public static String getClientAuthPassword() {
        return System.getProperty(CLIENT_AUTH_PASSWORD_PROPERTY, System.getenv(CLIENT_AUTH_PASSWORD_ENV) != null ? System.getenv(CLIENT_AUTH_PASSWORD_ENV) : HttpSettings.getAuthPassword());
    }

    public static String getServerAuthPassword() {
        return System.getProperty(SERVER_AUTH_PASSWORD_PROPERTY, System.getenv(SERVER_AUTH_PASSWORD_ENV) != null ? System.getenv(SERVER_AUTH_PASSWORD_ENV) : HttpSettings.getAuthPassword());
    }
}

